#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
i = 3
x = "parzysta" if i % 2 == 0 else "nieparzysta"
print(x)


print("Przykład 2")
def fail():
    raise Exception("Ups")

x = fail() if False else 20
print(x)


print("Przykład 3")
result = [x / 4 for x in range(10) if x % 2 == 0]
print(result)


print("Przykład 4")
x = (i % 2 == 0 and "parzysta") or "nieparzysta"


print("Przykład 5")
if i % 2 == 0:
    x = "parzysta"
else:
    x = "nieparzysta"


print("Przykład 6")
if i % 2 == 0:
    x = "parzysta"
    print("Wartość była parzysta!")  # Nowe polecenie
else:
    x = "nieparzysta"


print("Przykład 7")
if i % 2 == 0:
    x = "parzysta"
elif i % 3 == 0:  # Nowe polecenie
    x = "podzielna przez 3"
else:
    x = "nieparzysta"


print("Przykład 8")
def number_group(i):
    if i % 2 == 0:
        return "parzysta"
    else:
        return "nieparzysta"

x = number_group(i)  # Krótkie wywołanie
print(x)


print("Przykład 9")
def my_long_function_call(*args):
    pass

def my_other_long_function_call(*args):
    pass


x = (my_long_function_call(1, 2, 3) if i % 2 == 0
     else my_other_long_function_call(4, 5, 6))


print("Przykład 10")
x = (
    my_long_function_call(1, 2, 3)
    if i % 2 == 0
    else my_other_long_function_call(4, 5, 6)
)


print("Przykład 11")
x = 2
y = 1

if x and (z := x > y):
    pass


print("Przykład 12")
try:
    # Ten kod się nie skompiluje
    source = """if x and z := x > y:
        pass"""
    eval(source)
except:
    logging.exception('Oczekiwane')
else:
    assert False


print("Przykład 13")
if x > y if z else w:    # Zapis niejednoznaczny
    pass

if x > (y if z else w):  # Zapis czytelny
    pass


print("Przykład 14")
z = dict(
    your_value=(y := 1),
)


print("Przykład 15")
try:
    # Ten kod się nie skompiluje
    source = """w = dict(
        other_value=y := 1,
    )      """
    eval(source)
except:
    logging.exception('Oczekiwane')
else:
    assert False


print("Przykład 16")
v = dict(
    my_value=1 if x else 3,
)
