#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.



print("Przykład 9")
# Typy w pliku można sprawdzić za pomocą polecenia: python3 -m mypy <ścieżka>

from datetime import datetime
from time import sleep

def log_typed(message: str, when: datetime | None = None) -> None:
    """Wyświetlenie komunikatu debugowania wraz ze znacznikiem czasu

    Argumenty:
        message: Komunikat przeznaczony do wyświetlenia
        when: Data i godzina wyświetlenia tego komunikatu
            Wartości domyślne to aktualna data i godzina
    """
    if when is None:
        when = datetime.now()
    print(f"{when}: {message}")


log_typed("Witajcie!")
sleep(0.1)
log_typed("Witaj ponownie!")
log_typed("I jeszcze raz", when=datetime.now())
