#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
def palindrome(word):
    """Zwraca wartość True, jeżeli podane słowo jest palindromem."""
    return word == word[::-1]

assert palindrome("kajak")
assert not palindrome("banan")


print("Przykład 2")
print(palindrome.__doc__)


print("Przykład 3")
"""Biblioteka do testowania słów pod kątem różnych konstrukcji językowych.

Sprawdzenie sposobu wzajemnego powiązania słów czasami może być trudne!
Za pomocą tego modułu można łatwo ustalić, kiedy analizowane słowa
mają specjalne właściwości.

Dostępne funkcje:
- palindrome: określa, czy słowo jest palindromem.
- check_anagram: określa, czy dwa słowa są anagramami.
...
"""


print("Przykład 4")
class Player:
    """Przedstawia gracza w grze.

    Podklasy mogą nadpisywać metodę 'tick' w celu dostarczenia
    własnych animacji ruchu gracza, w zależności od siły gracza,
    aktualnego poziomu itd.

    Atrybuty publiczne:
    - power: dostępna siła (liczba zmiennoprzecinkowa od 0 do 1).
    - coins: monety znalezione na danym poziomie (liczba całkowita).
    """


print("Przykład 5")
import itertools

def find_anagrams(word, dictionary):
    """Wyszukuje wszystkie anagramy dla słowa.

    Ta funkcja działa szybko tylko wtedy, gdy sprawdzany
    będzie kontener w postaci słownika.

    Argumenty:
        word: ciąg tekstowy słowa docelowego.
        dictionary: kontener wraz z wszystkimi ciągami tekstowymi,
            które są rzeczywistymi słowami.

    Wartość zwrotna:
        Lista znalezionych anagramów. Jeżeli żaden nie
        zostanie znaleziony, wartość zwrotna jest pusta.
    """
    permutations = itertools.permutations(word, len(word))
    possible = ("".join(x) for x in permutations)
    found = {word for word in possible if word in dictionary}
    return list(found)


assert find_anagrams("pancakes", ["scanpeak"]) == ["scanpeak"]
