#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
def sort_priority(values, group):
    def helper(x):
        if x in group:
            return (0, x)
        return (1, x)

    values.sort(key=helper)


print("Przykład 2")
numbers = [8, 3, 1, 2, 5, 4, 7, 6]
group = {2, 3, 5, 7}
sort_priority(numbers, group)
print(numbers)


print("Przykład 3")
def sort_priority2(numbers, group):
    found = False         # Oznaczenie wartości początkowej

    def helper(x):
        if x in group:
            found = True  # Odwrócenie wartości początkowej
            return (0, x)
        return (1, x)

    numbers.sort(key=helper)
    return found          # Wartość końcowa


print("Przykład 4")
numbers = [8, 3, 1, 2, 5, 4, 7, 6]
found = sort_priority2(numbers, group)
print("Znaleziono:", found)
print(numbers)


print("Przykład 5")
try:
    foo = nieistniejący_klucz * 5
except:
    logging.exception('Oczekiwane')
else:
    assert False


print("Przykład 6")
def sort_priority2(numbers, group):
    found = False          # Zakres: funkcja sort_priority2()

    def helper(x):
        if x in group:
            found = True   # Zakres: funkcja domknięcia helper() -- niedobrze!
            return (0, x)
        return (1, x)

    numbers.sort(key=helper)
    return found


print("Przykład 7")
def sort_priority3(numbers, group):
    found = False

    def helper(x):
        nonlocal found  # Nowe polecenie
        if x in group:
            found = True
            return (0, x)
        return (1, x)

    numbers.sort(key=helper)
    return found


print("Przykład 8")
numbers = [8, 3, 1, 2, 5, 4, 7, 6]
found = sort_priority3(numbers, group)
print("Znaleziono:", found)
print(numbers)


print("Przykład 9")
class Sorter:
    def __init__(self, group):
        self.group = group
        self.found = False

    def __call__(self, x):
        if x in self.group:
            self.found = True
            return (0, x)
        return (1, x)


print("Przykład 10")
numbers = [8, 3, 1, 2, 5, 4, 7, 6]
sorter = Sorter(group)
numbers.sort(key=sorter)
print("Znaleziono:", sorter.found)
print(numbers)
