#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
import math
import functools

def log_sum(log_total, value):
    log_value = math.log(value)
    return log_total + log_value

result = functools.reduce(log_sum, [10, 20, 40], 0)
print(math.exp(result))


print("Przykład 2")
def log_sum_alt(value, log_total):  # Zmiana
    log_value = math.log(value)
    return log_total + log_value


print("Przykład 3")
result = functools.reduce(
    lambda total, value: log_sum_alt(value, total),  # Zmiana kolejności argumentów
    [10, 20, 40],
    0,
)
print(math.exp(result))


print("Przykład 4")
def log_sum_for_reduce(total, value):
    return log_sum_alt(value, total)

result = functools.reduce(
    log_sum_for_reduce,
    [10, 20, 40],
    0,
)
print(math.exp(result))


print("Przykład 5")
def logn_sum(base, logn_total, value):  # Nowy pierwszy parametr funkcji
    logn_value = math.log(value, base)
    return logn_total + logn_value


print("Przykład 6")
result = functools.reduce(
    lambda total, value: logn_sum(10, total, value),  # Zmiana
    [10, 20, 40],
    0,
)
print(math.pow(10, result))


print("Przykład 7")
result = functools.reduce(
    functools.partial(logn_sum, 10),  # Zmiana
    [10, 20, 40],
    0,
)
print(math.pow(10, result))


print("Przykład 8")
def logn_sum_last(logn_total, value, *, base=10):  # Nowy ostatni parametr funkcji
    logn_value = math.log(value, base)
    return logn_total + logn_value


print("Przykład 9")
import math

log_sum_e = functools.partial(logn_sum_last, base=math.e)  # Przypięta wartość argumentu `base`
print(log_sum_e(3, math.e**10))


print("Przykład 10")
log_sum_e_alt = lambda *a, base=math.e, **kw: logn_sum_last(*a, base=base, **kw)
print(log_sum_e_alt(3, math.e**10))


print("Przykład 11")
print(log_sum_e.args, log_sum_e.keywords, log_sum_e.func)
