#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2019 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Wygenerowanie wszystkich danych wyjściowych w katalogu tymczasowym.
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Prawidłowe zakończenie procesów w systemie Windows.
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)


# Przykład 1.
fresh_fruit = {
    'jabłko': 10,
    'banan': 8,
    'cytryna': 5,
}


# Przykład 2.
def make_lemonade(count):
    print(f'Przygotowanie lemoniady z {count} cytryn.')

def out_of_stock():
    print('Brak niezbędnych owoców!')

count = fresh_fruit.get('cytryna', 0)
if count:
    make_lemonade(count)
else:
    out_of_stock()


# Przykład 3.
if count := fresh_fruit.get('cytryna', 0):
    make_lemonade(count)
else:
    out_of_stock()


# Przykład 4.
def make_cider(count):
    print(f'Przygotowanie cydru z {count} jabłek.')

count = fresh_fruit.get('jabłko', 0)
if count >= 4:
    make_cider(count)
else:
    out_of_stock()


# Przykład 5.
if (count := fresh_fruit.get('jabłko', 0)) >= 4:
    make_cider(count)
else:
    out_of_stock()


# Przykład 6.
def slice_bananas(count):
    print(f'Krojenie {count} bananów.')
    return count * 4

class OutOfBananas(Exception):
    pass

def make_smoothies(count):
    print(f'Przygotowanie smoothie z {count} kawałkami bananów.')

pieces = 0
count = fresh_fruit.get('banan', 0)
if count >= 2:
    pieces = slice_bananas(count)

try:
    smoothies = make_smoothies(pieces)
except OutOfBananas:
    out_of_stock()


# Przykład 7.
count = fresh_fruit.get('banan', 0)
if count >= 2:
    pieces = slice_bananas(count)
else:
    pieces = 0

try:
    smoothies = make_smoothies(pieces)
except OutOfBananas:
    out_of_stock()


# Przykład 8.
pieces = 0
if (count := fresh_fruit.get('banan', 0)) >= 2:
    pieces = slice_bananas(count)

try:
    smoothies = make_smoothies(pieces)
except OutOfBananas:
    out_of_stock()


# Przykład 9.
if (count := fresh_fruit.get('banan', 0)) >= 2:
    pieces = slice_bananas(count)
else:
    pieces = 0

try:
    smoothies = make_smoothies(pieces)
except OutOfBananas:
    out_of_stock()


# Przykład 10.
count = fresh_fruit.get('banan', 0)
if count >= 2:
    pieces = slice_bananas(count)
    to_enjoy = make_smoothies(pieces)
else:
    count = fresh_fruit.get('jabłko', 0)
    if count >= 4:
        to_enjoy = make_cider(count)
    else:
        count = fresh_fruit.get('cytryna', 0)
        if count:
            to_enjoy = make_lemonade(count)
        else:
            to_enjoy = 'Brak napoju.'


# Przykład 11.
if (count := fresh_fruit.get('banan', 0)) >= 2:
    pieces = slice_bananas(count)
    to_enjoy = make_smoothies(pieces)
elif (count := fresh_fruit.get('jabłko', 0)) >= 4:
    to_enjoy = make_cider(count)
elif count := fresh_fruit.get('cytryna', 0):
    to_enjoy = make_lemonade(count)
else:
    to_enjoy = 'Brak napoju.'


# Przykład 12.
FRUIT_TO_PICK = [
    {'jabłko': 1, 'banan': 3},
    {'cytryna': 2, 'limetka': 5},
    {'pomarańcza': 3, 'melon': 2},
]

def pick_fruit():
    if FRUIT_TO_PICK:
        return FRUIT_TO_PICK.pop(0)
    else:
        return []

def make_juice(fruit, count):
    return [(fruit, count)]

bottles = []
fresh_fruit = pick_fruit()
while fresh_fruit:
    for fruit, count in fresh_fruit.items():
        batch = make_juice(fruit, count)
        bottles.extend(batch)
    fresh_fruit = pick_fruit()

print(bottles)


# Przykład 13.
FRUIT_TO_PICK = [
    {'jabłko': 1, 'banan': 3},
    {'cytryna': 2, 'limetka': 5},
    {'pomarańcza': 3, 'melon': 2},
]

bottles = []
while True:                     # Pętla...
    fresh_fruit = pick_fruit()
    if not fresh_fruit:         # ...plus pół pętli.
        break
    for fruit, count in fresh_fruit.items():
        batch = make_juice(fruit, count)
        bottles.extend(batch)

print(bottles)


# Przykład 14.
FRUIT_TO_PICK = [
    {'jabłko': 1, 'banan': 3},
    {'cytryna': 2, 'limetka': 5},
    {'pomarańcza': 3, 'melon': 2},
]

bottles = []
while fresh_fruit := pick_fruit():
    for fruit, count in fresh_fruit.items():
        batch = make_juice(fruit, count)
        bottles.extend(batch)

print(bottles)
