#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2019 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Wygenerowanie wszystkich danych wyjściowych w katalogu tymczasowym.
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Prawidłowe zakończenie procesów w systemie Windows.
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)


# Przykład 1.
try:
    car_ages = [0, 9, 4, 8, 7, 20, 19, 1, 6, 15]
    car_ages_descending = sorted(car_ages, reverse=True)
    oldest, second_oldest = car_ages_descending
except:
    logging.exception('Wystąpił błąd w kodzie wywołującym.')
else:
    assert False


# Przykład 2.
oldest = car_ages_descending[0]
second_oldest = car_ages_descending[1]
others = car_ages_descending[2:]
print(oldest, second_oldest, others)


# Przykład 3.
oldest, second_oldest, *others = car_ages_descending
print(oldest, second_oldest, others)


# Przykład 4.
oldest, *others, youngest = car_ages_descending
print(oldest, youngest, others)

*others, second_youngest, youngest = car_ages_descending
print(youngest, second_youngest, others)


# Przykład 5.
try:
    # Ten fragment kodu się nie kompiluje.
    source = """*others = car_ages_descending"""
    eval(source)
except:
    logging.exception('Wystąpił błąd w kodzie wywołującym.')
else:
    assert False


# Przykład 6.
try:
    # Ten fragment kodu się nie kompiluje.
    source = """first, *middle, *second_middle, last = [1, 2, 3, 4]"""
    eval(source)
except:
    logging.exception('Wystąpił błąd w kodzie wywołującym.')
else:
    assert False


# Przykład 7.
car_inventory = {
	'lokal': ('Silver Shadow', 'Pinto', 'DMC'),
	'port lotniczy': ('Skyline', 'Viper', 'Gremlin', 'Nova'),
}

((loc1, (best1, *rest1)),
 (loc2, (best2, *rest2))) = car_inventory.items()

print(f'Najlepszy {loc1} to {best1}, {len(rest1)} inne')
print(f'Najlepszy {loc2} to {best2}, {len(rest2)} inne')


# Przykład 8.
short_list = [1, 2]
first, second, *rest = short_list
print(first, second, rest)


# Przykład 9.
it = iter(range(1, 3))
first, second = it
print(f'{first} i {second}')


# Przykład 10.
def generate_csv():
	yield ('Data', 'Marka', 'Model', 'Rok', 'Cena')
	for i in range(100):
		yield ('2019-03-25', 'Honda', 'Fit' , '2010', '34000 zł')
		yield ('2019-03-26', 'Ford', 'F150' , '2008', '24000 zł')


# Przykład 11.
all_csv_rows = list(generate_csv())
header = all_csv_rows[0]
rows = all_csv_rows[1:]
print('Nagłówek CSV:', header)
print('Liczba rekordów: ', len(rows))


# Przykład 12.
it = generate_csv()
header, *rows = it
print('Nagłówek CSV:', header)
print('Liczba rekordów: ', len(rows))
