#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2019 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.



# Przykład 9.
# Typy w tym pliku sprawdź za pomocą polecenia: python -m mypy <ścieżka dostępu>.

from datetime import datetime
from time import sleep
from typing import Optional

def log_typed(message: str,
              when: Optional[datetime]=None) -> None:
    """Wyświetlenie komunikatu debugowania wraz ze znacznikiem czasu.

    Argumenty:
        message: Komunikat przeznaczony do wyświetlenia.
        when: Data i godzina wyświetlenia tego komunikatu.
            Wartości domyślne to aktualna data i godzina.
    """
    if when is None:
        when = datetime.now()
    print(f'{when}: {message}')

log_typed('Witaj!')
sleep(0.1)
log_typed('Witaj ponownie!')
