#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2019 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Wygenerowanie wszystkich danych wyjściowych w katalogu tymczasowym.
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Prawidłowe zakończenie procesów w systemie Windows.
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)


# Przykład 2.
baby_names = {
    'kot': 'mruczek',
    'pies': 'pimpek',
}
print(baby_names)


# Przykład 4.
print(list(baby_names.keys()))
print(list(baby_names.values()))
print(list(baby_names.items()))
print(baby_names.popitem())  # Ostatni wstawiony element.


# Przykład 6.
def my_func(**kwargs):
    for key, value in kwargs.items():
        print(f'{key} = {value}')

my_func(gęś='gąska', kangur='kangurek')


# Przykład 8.
class MyClass:
    def __init__(self):
        self.alligator = 'aligator'
        self.elephant = 'słoń'

a = MyClass()
for key, value in a.__dict__.items():
    print(f'{key} = {value}')


# Przykład 9.
votes = {
    'wydra': 1281,
    'miś polarny': 587,
    'lis': 863,
}


# Przykład 10.
def populate_ranks(votes, ranks):
    names = list(votes.keys())
    names.sort(key=votes.get, reverse=True)
    for i, name in enumerate(names, 1):
        ranks[name] = i


# Przykład 11.
def get_winner(ranks):
    return next(iter(ranks))


# Przykład 12.
ranks = {}
populate_ranks(votes, ranks)
print(ranks)
winner = get_winner(ranks)
print(winner)


# Przykład 13.
from collections.abc import MutableMapping

class SortedDict(MutableMapping):
    def __init__(self):
        self.data = {}

    def __getitem__(self, key):
        return self.data[key]

    def __setitem__(self, key, value):
        self.data[key] = value

    def __delitem__(self, key):
        del self.data[key]

    def __iter__(self):
        keys = list(self.data.keys())
        keys.sort()
        for key in keys:
            yield key

    def __len__(self):
        return len(self.data)

my_dict = SortedDict()
my_dict['wydra'] = 1
my_dict['gepard'] = 2
my_dict['mrówkojad'] = 3
my_dict['jeleń'] = 4

assert my_dict['wydra'] == 1

assert 'gepard' in my_dict
del my_dict['gepard']
assert 'gepard' not in my_dict

expected = [('mrówkojad', 3), ('jeleń', 4), ('wydra', 1)]
assert list(my_dict.items()) == expected

assert not isinstance(my_dict, dict)


# Przykład 14.
sorted_ranks = SortedDict()
populate_ranks(votes, sorted_ranks)
print(sorted_ranks.data)
winner = get_winner(sorted_ranks)
print(winner)


# Przykład 15.
def get_winner(ranks):
    for name, rank in ranks.items():
        if rank == 1:
            return name

winner = get_winner(sorted_ranks)
print(winner)


# Przykład 16.
try:
    def get_winner(ranks):
        if not isinstance(ranks, dict):
            raise TypeError('Wymagane jest użycie typu dict.')
        return next(iter(ranks))
    
    assert get_winner(ranks) == 'wydra'
    
    get_winner(sorted_ranks)
except:
    logging.exception('Wystąpił błąd w kodzie wywołującym.')
else:
    assert False
