/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SourceInDemo
extends JFrame {
    private JCheckBox shadow;

    public SourceInDemo() {
        super("Regu\u0142a Source In");
        this.add((Component)new ImageViewer(), "Center");
        JPanel panel = new JPanel(new FlowLayout(3));
        this.shadow = new JCheckBox("Dodaj cie\u0144");
        panel.add(this.shadow);
        this.shadow.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SourceInDemo.this.repaint();
            }
        });
        this.add((Component)panel, "South");
        this.setSize(350, 250);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new SourceInDemo().setVisible(true);
            }
        });
    }

    private class ImageViewer
    extends JComponent {
        private BufferedImage image;
        private BufferedImage landscape;

        private ImageViewer() {
            try {
                this.image = ImageIO.read(this.getClass().getResource("picture.png"));
                this.landscape = ImageIO.read(this.getClass().getResource("landscape.jpg"));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        protected void paintComponent(Graphics g) {
            BufferedImage temp = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D g2 = temp.createGraphics();
            if (SourceInDemo.this.shadow.isSelected()) {
                int x = (this.getWidth() - this.image.getWidth()) / 2;
                int y = (this.getHeight() - this.image.getHeight()) / 2;
                g2.drawImage((Image)this.image, x + 4, y + 10, null);
                Composite oldComposite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(5, 0.75f));
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.setComposite(oldComposite);
                g2.drawImage((Image)this.image, x, y, null);
            } else {
                int x = (this.getWidth() - this.image.getWidth()) / 2;
                int y = (this.getHeight() - this.image.getHeight()) / 2;
                g2.drawImage((Image)this.image, x, y, null);
            }
            g2.dispose();
            g.drawImage(temp, 0, 0, null);
        }
    }
}

