/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.triggers;

import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.triggers.ChangeTriggerEvent;
import org.jdesktop.animation.timing.triggers.Trigger;
import org.jdesktop.animation.timing.triggers.TriggerEvent;
import org.jdesktop.animation.timing.triggers.TriggerListener;

public class ChangeTrigger
extends Trigger {
    public ChangeTrigger(TimingController timer, ButtonModel source, Trigger.TriggerAction action, ChangeTriggerEvent event) {
        this.setupListener(timer, source, action, event);
    }

    public ChangeTrigger(TimingController startTimer, ButtonModel source, ChangeTriggerEvent event, TimingController stopTimer) {
        super(startTimer, source, event, stopTimer);
    }

    public void setupListener(TimingController timer, Object source, Trigger.TriggerAction action, TriggerEvent event) {
        try {
            ChangeTriggerListener listener = new ChangeTriggerListener(timer, action, (ChangeTriggerEvent)event, (ButtonModel)source);
            this.setupListener(source, listener, "addChangeListener", ChangeListener.class);
        }
        catch (Exception e) {
            System.out.println("Exception creating change listener for object " + source + ": " + e);
        }
    }

    class ChangeTriggerListener
    extends TriggerListener
    implements ChangeListener {
        boolean armed;
        boolean rollover;
        ChangeTriggerEvent event;

        protected ChangeTriggerListener(TimingController timer, Trigger.TriggerAction action, ChangeTriggerEvent event, ButtonModel model) {
            super(timer, action);
            this.event = event;
            this.armed = model.isArmed();
            this.rollover = model.isRollover();
        }

        public void stateChanged(ChangeEvent ae) {
            boolean rolloverChange;
            ButtonModel model = (ButtonModel)ae.getSource();
            boolean armedChange = this.armed != model.isArmed();
            boolean bl = rolloverChange = this.rollover != model.isRollover();
            if (armedChange) {
                if (this.event == ChangeTriggerEvent.ARMED && model.isArmed() || this.event == ChangeTriggerEvent.DISARMED && !model.isArmed()) {
                    this.pullTrigger();
                }
                this.armed = model.isArmed();
            }
            if (rolloverChange) {
                if (this.event == ChangeTriggerEvent.ROLLOVER && model.isRollover() || this.event == ChangeTriggerEvent.ROLLOFF && !model.isRollover()) {
                    this.pullTrigger();
                }
                this.rollover = model.isRollover();
            }
        }
    }
}

