/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing;

public class Envelope {
    private double repeatCount;
    private int begin;
    private RepeatBehavior repeatBehavior;
    private EndBehavior endBehavior;

    public Envelope(double repeatCount, int begin, RepeatBehavior repeatBehavior, EndBehavior endBehavior) {
        if (begin < 0 || endBehavior == null || repeatCount != -1.0 && repeatCount <= 0.0) {
            String errorMessage = "Errors: ";
            if (begin < 0) {
                errorMessage = errorMessage + "begin " + begin + " cannot be negative\n";
            }
            if (endBehavior == null) {
                errorMessage = errorMessage + "endBehavior cannot be null\n";
            }
            if (repeatCount != -1.0 && repeatCount <= 0.0) {
                errorMessage = errorMessage + "cannot have zero or negative value of repeatCount (" + repeatCount + ")\n";
            }
            throw new IllegalArgumentException(errorMessage);
        }
        this.repeatCount = repeatCount;
        this.begin = begin;
        this.repeatBehavior = repeatBehavior;
        this.endBehavior = endBehavior;
    }

    public double getRepeatCount() {
        return this.repeatCount;
    }

    public int getBegin() {
        return this.begin;
    }

    public RepeatBehavior getRepeatBehavior() {
        return this.repeatBehavior;
    }

    public EndBehavior getEndBehavior() {
        return this.endBehavior;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RepeatBehavior {
        FORWARD,
        REVERSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EndBehavior {
        HOLD,
        RESET;

    }
}

