/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class PictureGlassPane
extends JComponent {
    private BufferedImage image;
    private Point location;
    private BufferedImage shadow;

    public void moveIt(Point location) {
        Point oldLocation = this.location;
        SwingUtilities.convertPointFromScreen(location, this);
        this.location = location;
        Rectangle newClip = new Rectangle(location.x - this.image.getWidth() / 2, location.y - this.image.getHeight() / 2, this.image.getWidth(), this.image.getHeight());
        newClip.add(new Rectangle(oldLocation.x - this.image.getWidth() / 2, oldLocation.y - this.image.getHeight() / 2, this.image.getWidth(), this.image.getHeight()));
        newClip.add(new Rectangle(oldLocation.x - this.image.getWidth() / 2, oldLocation.y - this.image.getHeight() / 2, this.shadow.getWidth(), this.shadow.getHeight()));
        newClip.add(new Rectangle(location.x - this.image.getWidth() / 2, location.y - this.image.getHeight() / 2, this.shadow.getWidth(), this.shadow.getHeight()));
        this.repaint(newClip);
    }

    public void hideIt() {
        this.setVisible(false);
    }

    public void showIt(BufferedImage image, Point location) {
        this.image = image;
        this.shadow = new ShadowRenderer(5, 0.3f, Color.BLACK).createShadow(image);
        SwingUtilities.convertPointFromScreen(location, this);
        this.location = location;
        this.setVisible(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.image != null && this.location != null) {
            int x = this.location.x - this.image.getWidth() / 2;
            int y = this.location.y - this.image.getHeight() / 2;
            g.drawImage(this.shadow, x, y, null);
            g.drawImage(this.image, x, y, null);
        }
    }
}

