#!/usr/bin/env python3

# Copyright 2014 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import logging
from pprint import pprint
from sys import stdout as STDOUT


# Przykład 1.
class MyObject(object):
    def __init__(self):
        self.public_field = 5
        self.__private_field = 10

    def get_private_field(self):
        return self.__private_field


# Przykład 2.
foo = MyObject()
assert foo.public_field == 5


# Przykład 3.
assert foo.get_private_field() == 10


# Przykład 4.
try:
    foo.__private_field
except:
    logging.exception('Oczekiwany')
else:
    assert False


# Przykład 5.
class MyOtherObject(object):
    def __init__(self):
        self.__private_field = 71

    @classmethod
    def get_private_field_of_instance(cls, instance):
        return instance.__private_field

bar = MyOtherObject()
assert MyOtherObject.get_private_field_of_instance(bar) == 71


# Przykład 6.
try:
    class MyParentObject(object):
        def __init__(self):
            self.__private_field = 71
    
    class MyChildObject(MyParentObject):
        def get_private_field(self):
            return self.__private_field
    
    baz = MyChildObject()
    baz.get_private_field()
except:
    logging.exception('Oczekiwany')
else:
    assert False


# Przykład 7.
assert baz._MyParentObject__private_field == 71


# Przykład 8.
print(baz.__dict__)


# Przykład 9.
class MyClass(object):
    def __init__(self, value):
        self.__value = value

    def get_value(self):
        return str(self.__value)

foo = MyClass(5)
assert foo.get_value() == '5'


# Przykład 10.
class MyIntegerSubclass(MyClass):
    def get_value(self):
        return int(self._MyClass__value)

foo = MyIntegerSubclass(5)
assert foo.get_value() == 5


# Przykład 11.
class MyBaseClass(object):
    def __init__(self, value):
        self.__value = value

    def get_value(self):
        return self.__value

class MyClass(MyBaseClass):
    def get_value(self):
        return str(super().get_value())

class MyIntegerSubclass(MyClass):
    def get_value(self):
        return int(self._MyClass__value)


# Przykład 12.
try:
    foo = MyIntegerSubclass(5)
    foo.get_value()
except:
    logging.exception('Oczekiwany')
else:
    assert False


# Przykład 13.
class MyClass(object):
    def __init__(self, value):
        # Kod przechowuje podaną przez użytkownika wartość dla obiektu.
        # To powinien być ciąg tekstowy. Po przypisaniu obiektowi,
        # powinien być traktowany jako niemodyfikowalny.
        self._value = value

    def get_value(self):
        return str(self._value)

class MyIntegerSubclass(MyClass):
    def get_value(self):
        return self._value

foo = MyIntegerSubclass(5)
assert foo.get_value() == 5


# Przykład 14.
class ApiClass(object):
    def __init__(self):
        self._value = 5

    def get(self):
        return self._value

class Child(ApiClass):
    def __init__(self):
        super().__init__()
        self._value = 'witaj'  # Konflikty.

a = Child()
print(a.get(), 'i', a._value, 'powinny być różnymi wartościami')


# Przykład 15.
class ApiClass(object):
    def __init__(self):
        self.__value = 5

    def get(self):
        return self.__value

class Child(ApiClass):
    def __init__(self):
        super().__init__()
        self._value = 'witaj'  # OK!

a = Child()
print(a.get(), 'i', a._value, 'są różnymi wartościami')
