#!/usr/bin/env python3

# Copyright 2014 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import logging
from pprint import pprint
from sys import stdout as STDOUT


# Przykład 1.
handle = open('/tmp/random_data.txt', 'w', encoding='utf-8')
handle.write('success\nand\nnew\nlines')
handle.close()
handle = open('/tmp/random_data.txt')  # Może spowodować zgłoszenie wyjątku IOError.
try:
    data = handle.read()  # Może spowodować zgłoszenie wyjątku UnicodeDecodeError.
finally:
    handle.close()        # Zawsze wykonywane po bloku try.


# Przykład 2.
import json

def load_json_key(data, key):
    try:
        result_dict = json.loads(data)  # Może spowodować zgłoszenie wyjątku ValueError.
    except ValueError as e:
        raise KeyError from e
    else:
        return result_dict[key]         # Może spowodować zgłoszenie wyjątku KeyError.

# Dekodowanie JSON zakończone powodzeniem.
assert load_json_key('{"foo": "bar"}', 'foo') == 'bar'
try:
    load_json_key('{"foo": "bar"}', 'nie istnieje')
    assert False
except KeyError:
    pass  # Oczekiwane.

# Dekodowanie JSON zakończone niepowodzeniem.
try:
    load_json_key('{"foo": błędne dane', 'foo')
    assert False
except KeyError:
    pass  # Oczekiwane.


# Przykład 3.
import json
UNDEFINED = object()

def divide_json(path):
    handle = open(path, 'r+')   # Może spowodować zgłoszenie wyjątku IOError.
    try:
        data = handle.read()    # Może spowodować zgłoszenie wyjątku UnicodeDecodeError.
        op = json.loads(data)   # May raise ValueError
        value = (
            op['numerator'] /
            op['denominator'])  # Może spowodować zgłoszenie wyjątku ZeroDivisionError.
    except ZeroDivisionError as e:
        return UNDEFINED
    else:
        op['result'] = value
        result = json.dumps(op)
        handle.seek(0)
        handle.write(result)    # Może spowodować zgłoszenie wyjątku IOError.
        return value
    finally:
        handle.close()          # Zawsze wykonywane.

# Wszystko działa.
temp_path = '/tmp/random_data.json'
handle = open(temp_path, 'w')
handle.write('{"numerator": 1, "denominator": 10}')
handle.close()
assert divide_json(temp_path) == 0.1

# Dzielenie przez zero.
handle = open(temp_path, 'w')
handle.write('{"numerator": 1, "denominator": 0}')
handle.close()
assert divide_json(temp_path) is UNDEFINED

# Błąd w trakcie dekodowania danych JSON.
handle = open(temp_path, 'w')
handle.write('{"numerator": 1 błędne dane')
handle.close()
try:
    divide_json(temp_path)
    assert False
except ValueError:
    pass  # Oczekiwane.
