#!/usr/bin/env python3

# Copyright 2014 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import logging
from pprint import pprint
from sys import stdout as STDOUT


# Przykład 1.
from urllib.parse import parse_qs
my_values = parse_qs('red=5&blue=0&green=',
                     keep_blank_values=True)
print(repr(my_values))


# Przykład 2.
print('Czerwony: ', my_values.get('red'))
print('Zielony:  ', my_values.get('green'))
print('Krycie:   ', my_values.get('opacity'))


# Przykład 3.
# Dla ciągu tekstowego zapytania'red=5&blue=0&green='
red = my_values.get('red', [''])[0] or 0
green = my_values.get('green', [''])[0] or 0
opacity = my_values.get('opacity', [''])[0] or 0
print('Czerwony: %r' % red)
print('Zielony:  %r' % green)
print('Krycie:   %r' % opacity)


# Przykład 4.
red = int(my_values.get('red', [''])[0] or 0)
green = int(my_values.get('green', [''])[0] or 0)
opacity = int(my_values.get('opacity', [''])[0] or 0)
print('Czerwony: %r' % red)
print('Zielony:  %r' % green)
print('Krycie:   %r' % opacity)


# Przykład 5.
red = my_values.get('red', [''])
red = int(red[0]) if red[0] else 0
green = my_values.get('green', [''])
green = int(green[0]) if green[0] else 0
opacity = my_values.get('opacity', [''])
opacity = int(opacity[0]) if opacity[0] else 0
print('Czerwony: %r' % red)
print('Zielony:  %r' % green)
print('Krycie:   %r' % opacity)


# Przykład 6.
green = my_values.get('green', [''])
if green[0]:
    green = int(green[0])
else:
    green = 0
print('Zielony: %r' % green)


# Przykład 7.
def get_first_int(values, key, default=0):
    found = values.get(key, [''])
    if found[0]:
        found = int(found[0])
    else:
        found = default
    return found


# Przykład 8.
green = get_first_int(my_values, 'green')
print('Zielony: %r' % green)
