#!/usr/bin/env python3

# Copyright 2014 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import logging
from pprint import pprint
from sys import stdout as STDOUT


# Przykład 1.
def divide(a, b):
    try:
        return a / b
    except ZeroDivisionError:
        return None

assert divide(4, 2) == 2
assert divide(0, 1) == 0
assert divide(3, 6) == 0.5
assert divide(1, 0) == None


# Przykład 2.
x, y = 1, 0
result = divide(x, y)
if result is None:
    print('Nieprawidłowe dane wejściowe')
else:
    print('Wynik operacji to %.1f' % result)


# Przykład 3.
x, y = 0, 5
result = divide(x, y)
if not result:
    print('Nieprawidłowe dane wejściowe')  # To nieprawidłowe podejście!
else:
    assert False


# Przykład 4.
def divide(a, b):
    try:
        return True, a / b
    except ZeroDivisionError:
        return False, None


# Przykład 5.
x, y = 5, 0
success, result = divide(x, y)
if not success:
    print('Nieprawidłowe dane wejściowe')


# Przykład 6.
x, y = 5, 0
_, result = divide(x, y)
if not result:
    print('Nieprawidłowe dane wejściowe')


# Przykład 7.
def divide(a, b):
    try:
        return a / b
    except ZeroDivisionError as e:
        raise ValueError('Nieprawidłowe dane wejściowe') from e


# Przykład 8.
x, y = 5, 2
try:
    result = divide(x, y)
except ValueError:
    print('Nieprawidłowe dane wejściowe')
else:
    print('Wynik operacji to %.1f' % result)
