#!/usr/bin/env python3

# Copyright 2014 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import logging
from pprint import pprint
from sys import stdout as STDOUT


# Przykład 1.
try:
    def determine_weight(volume, density):
        if density <= 0:
            raise ValueError('Gęstość musi być wartością dodatnią')
    
    determine_weight(1, 0)
except:
    logging.exception('Oczekiwany')
else:
    assert False


# Przykład 2.
# my_module.py
class Error(Exception):
    """Klasa bazowa dla wszystkich wyjątków zgłaszanych przez ten moduł."""

class InvalidDensityError(Error):
    """Wystąpił problem z podaną wartością gęstości."""


# Przykład 3.
class my_module(object):
    Error = Error
    InvalidDensityError = InvalidDensityError

    @staticmethod
    def determine_weight(volume, density):
        if density <= 0:
            raise InvalidDensityError('Gęstość musi być wartością dodatnią')
try:
    weight = my_module.determine_weight(1, -1)
    assert False
except my_module.Error as e:
    logging.error('Nieoczekiwany błąd: %s', e)


# Przykład 4.
weight = 5
try:
    weight = my_module.determine_weight(1, -1)
    assert False
except my_module.InvalidDensityError:
    weight = 0
except my_module.Error as e:
    logging.error('Wystąpił błąd w kodzie wywołującym: %s', e)

assert weight == 0


# Przykład 5.
weight = 5
try:
    weight = my_module.determine_weight(1, -1)
    assert False
except my_module.InvalidDensityError:
    weight = 0
except my_module.Error as e:
    logging.error('Wystąpił błąd w kodzie wywołującym: %s', e)
except Exception as e:
    logging.error('Wystąpił błąd w kodzie API: %s', e)
    raise

assert weight == 0


# Przykład 6.
# my_module.py
class NegativeDensityError(InvalidDensityError):
    """Podano ujemną wartość dla gęstości."""

def determine_weight(volume, density):
    if density < 0:
        raise NegativeDensityError


# Przykład 7.
try:
    my_module.NegativeDensityError = NegativeDensityError
    my_module.determine_weight = determine_weight
    try:
        weight = my_module.determine_weight(1, -1)
        assert False
    except my_module.NegativeDensityError as e:
        raise ValueError('Wartość dla gęstości musi być dodatnia') from e
    except my_module.InvalidDensityError:
        weight = 0
    except my_module.Error as e:
        logging.error('Wystąpił błąd w kodzie wywołującym: %s', e)
    except Exception as e:
        logging.error('Wystąpił błąd w kodzie API: %s', e)
        raise
except:
    logging.exception('Oczekiwany')
else:
    assert False


# Przykład 8.
# my_module.py
class WeightError(Error):
    """Klasa bazowa dla błędów związanych z obliczaniem wagi."""

class VolumeError(Error):
    """Klasa bazowa dla błędów związanych z obliczaniem pojemności."""

class DensityError(Error):
    """Klasa bazowa dla błędów związanych z obliczaniem gęstości."""
