#!/usr/bin/env python3

# Copyright 2014 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import logging
from pprint import pprint
from sys import stdout as STDOUT


# Przykład 1.
class Homework(object):
    def __init__(self):
        self._grade = 0

    @property
    def grade(self):
        return self._grade

    @grade.setter
    def grade(self, value):
        if not (0 <= value <= 100):
            raise ValueError('Ocena musi być wartością z zakresu od 0 do 100')
        self._grade = value


# Przykład 2.
galileo = Homework()
galileo.grade = 95
print(galileo.grade)


# Przykład 3.
class Exam(object):
    def __init__(self):
        self._writing_grade = 0
        self._math_grade = 0

    @staticmethod
    def _check_grade(value):
        if not (0 <= value <= 100):
            raise ValueError('Ocena musi być wartością z zakresu od 0 do 100')


# Przykład 4.
    @property
    def writing_grade(self):
        return self._writing_grade

    @writing_grade.setter
    def writing_grade(self, value):
        self._check_grade(value)
        self._writing_grade = value

    @property
    def math_grade(self):
        return self._math_grade

    @math_grade.setter
    def math_grade(self, value):
        self._check_grade(value)
        self._math_grade = value


# Przykład 5.
galileo = Exam()
galileo.writing_grade = 85
galileo.math_grade = 99
print('Pisanie:    %5r' % galileo.writing_grade)
print('Matematyka: %5r' % galileo.math_grade)


# Przykład 6.
class Grade(object):
    def __get__(*args, **kwargs):
        pass

    def __set__(*args, **kwargs):
        pass

class Exam(object):
    # Atrybuty klasy.
    math_grade = Grade()
    writing_grade = Grade()
    science_grade = Grade()


# Przykład 7.
exam = Exam()
exam.writing_grade = 40


# Przykład 8.
Exam.__dict__['writing_grade'].__set__(exam, 40)


# Przykład 9.
print(exam.writing_grade)


# Przykład 10.
print(Exam.__dict__['writing_grade'].__get__(exam, Exam))


# Przykład 11.
class Grade(object):
    def __init__(self):
        self._value = 0

    def __get__(self, instance, instance_type):
        return self._value

    def __set__(self, instance, value):
        if not (0 <= value <= 100):
            raise ValueError('Ocena musi być wartością z zakresu od 0 do 100')
        self._value = value

class Exam(object):
    math_grade = Grade()
    writing_grade = Grade()
    science_grade = Grade()


# Przykład 12.
first_exam = Exam()
first_exam.writing_grade = 82
first_exam.science_grade = 99
print('Pisanie', first_exam.writing_grade)
print('Nauka', first_exam.science_grade)


# Przykład 13.
second_exam = Exam()
second_exam.writing_grade = 75
print('Drugi', second_exam.writing_grade, 'jest dobry')
print('Pierwszy', first_exam.writing_grade, 'jest niedobry')


# Przykład 14.
class Grade(object):
    def __init__(self):
        self._values = {}

    def __get__(self, instance, instance_type):
        if instance is None: return self
        return self._values.get(instance, 0)

    def __set__(self, instance, value):
        if not (0 <= value <= 100):
            raise ValueError('Ocena musi być wartością z zakresu od 0 do 100')
        self._values[instance] = value


# Przykład 15.
from weakref import WeakKeyDictionary

class Grade(object):
    def __init__(self):
        self._values = WeakKeyDictionary()
    def __get__(self, instance, instance_type):
        if instance is None: return self
        return self._values.get(instance, 0)

    def __set__(self, instance, value):
        if not (0 <= value <= 100):
            raise ValueError('Ocena musi być wartością z zakresu od 0 do 100')
        self._values[instance] = value


# Przykład 16.
class Exam(object):
    math_grade = Grade()
    writing_grade = Grade()
    science_grade = Grade()

first_exam = Exam()
first_exam.writing_grade = 82
second_exam = Exam()
second_exam.writing_grade = 75
print('Pierwszy', first_exam.writing_grade, 'jest dobry')
print('Drugi', second_exam.writing_grade, 'jest dobry')
