<?php

// Skrypt zarządza listą produktów w przechowalni.
// Praca nad skryptem rozpoczyna się w rozdziale 9.

// Dołącz plik konfiguracyjny przed kodem PHP:
require ('./includes/config.inc.php');

// Sprawdź lub utwórz sesję:
if (isset($_COOKIE['SESSION'])) {
	$uid = $_COOKIE['SESSION'];
} else {
	$uid = md5(uniqid('biped',true));
}

// Wyślij ciasteczko:
setcookie('SESSION', $uid, time()+(60*60*24*30));

// Dołącz plik nagłówka:
$page_title = 'Kawy świata - przechowalnia';
include ('./includes/header.html');

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require (MYSQL);

// Dołącz skrypt zawierający funkjce pomocnicze:
include ('./includes/product_functions.inc.php');

// Jeśli w adresei URL znajduje się numer SKU, rozdziel go na części:
if (isset($_GET['sku'])) {
	list($sp_type, $pid) = parse_sku($_GET['sku']);
}

if (isset ($sp_type, $pid, $_GET['action']) && ($_GET['action'] == 'remove') ) { // Usuń w przechowalni.
	
	$r = mysqli_query($dbc, "CALL remove_from_wish_list('$uid', '$sp_type', $pid)");

} elseif (isset ($sp_type, $pid, $_GET['action'], $_GET['qty']) && ($_GET['action'] == 'move') ) { // Przenieś do przechowalni.

	// Określ ilość:
	$qty = (filter_var($_GET['qty'], FILTER_VALIDATE_INT, array('min_range' => 1))) ? $_GET['qty'] : 1;

	// Dodaj do przechowalni:
	$r = mysqli_query($dbc, "CALL add_to_wish_list('$uid', '$sp_type', $pid, $qty)");
	
	// Na potrzeby debugowania:
	//if (!$r) echo mysqli_error($dbc);
	
	// Usuń z koszyka:
	$r = mysqli_query($dbc, "CALL remove_from_cart('$uid', '$sp_type', $pid)");
	
	// Na potrezby debugowania:
	//if (!$r) echo mysqli_error($dbc);

} elseif (isset($_POST['quantity'])) { // Zaktualizuj ilości w przechowalni.
	
	// Przejdź przez wszystkie pozycje:
	foreach ($_POST['quantity'] as $sku => $qty) {
		
		// Przetwarzaj numer SKU:
		list($sp_type, $pid) = parse_sku($sku);
		
		if (isset($sp_type, $pid)) {

			// Określ ilość:
			$qty = (filter_var($qty, FILTER_VALIDATE_INT, array('min_range' => 0))) ? $qty : 1;

			// Zaktualizuj ilości w przechowalni:
			$r = mysqli_query($dbc, "CALL update_wish_list('$uid', '$sp_type', $pid, $qty)");

			}

		} // Koniec pętli FOREACH.
	
}// Koniec głównej instrukcji IF.
		
// Pobierz zawartość przechowalni:
$r = mysqli_query($dbc, "CALL get_wish_list_contents('$uid')");

if (mysqli_num_rows($r) > 0) { // Do wyświetlenia!
	include ('./views/wishlist.html');
} else { // Pusta przechowalnia!
	include ('./views/emptylist.html');
}

// Dołącz plik stopki:
include ('./includes/footer.html');
?>
