<?php

// W skrypcie są zdefiniowane funkcje używane w katalogu.
// Praca nad skryptem rozpoczyna się w rozdziale 8.

// Funkcja określająca dostępność.
// Przyjmuje jeden argument - stan magazynowy (jako liczbę całkowitą).
// Zwraca łańcuch tekstowy.
function get_stock_status($stock) {
	
	if ($stock > 5) { // Mnóstwo!
		return 'Dostępne';
	} elseif ($stock > 0) { // Mało!
		return 'Niski stan magazynowy';
	} else { // Brak!
		return 'Obecnie niedostępne';
	}
	
} // Koniec funkcji get_stock_status().

// Funkcja określająca cenę.
// Bierze pod uwagę możliwość przeceny.
// Przyjmuje trzy argumenty: typ produktu, zwykłą cenę i cenę w promocji.
// Zwraca łańcuch tekstowy.
function get_price($type, $regular, $sales) {
	
	// Sposób ustalania opisu ceny zależy od typu produktu:
	if ($type == 'kawa') {
		
		// Cenę w promocji dodaj tylko wtedy, gdy jest większa od 0 
		// i mniejsza niż zwykła cena:
		if ((0 < $sales) && ($sales < $regular)) {
			return ' W promocji: ' . $sales . ' zł!';
		}
		
	} elseif ($type == 'gadzety') {
		
		// Cenę w promocji dodaj tylko wtedy, gdy jest większa od 0 
		// i mniejsza niż zwykła cena:
		if ((0 < $sales) && ($sales < $regular)) {
			return "<strong>Cena w promocji:</strong> $sales zł! (normalna $regular zł)<br />";
		} else {
			// W przeciwnym przypadku wyświetl tylko zwykłą cenę:
			return '<strong>Cena:</strong> ' . $regular . ' zł<br />';			
		}		
		
	}
	
} // Koniec funkcji get_price().

// Funkcja wybierająca cenę.
// Bierze pod uwagę możliwość przeceny.
// Przyjmuje dwa argumenty: zwykłą cenę i cenę w promocji.
// Zwraca liczbę zmiennoprzecinkową.
function get_just_price($regular, $sales) {
	
	// Zwróć cenę w promocji, jeśli spełnione są warunki:
	if ((0 < $sales) && ($sales < $regular)) {
		return number_format($sales, 2);
	} else {
		return number_format($regular, 2);
	}
	
} // Koniec funkcji get_just_price().

// Przetwarzanie numeru SKU.
// Przyjmuje jeden argument: numer SKU (np. K390 lub I28).
// Zwraca tablicę.
function parse_sku($sku) {
	
	// Wyciągnij pierwszy znak:
	$type_abbr = substr($sku, 0, 1);
	
	// Wyciągnij pozostałe znaki:
	$pid = substr($sku, 1);	
	
	// Sprawdź typ:
	if ($type_abbr == 'K') {
		$sp_type = 'kawa';
	} elseif ($type_abbr == 'I') {
		$sp_type = 'inne';
	} else {
		$sp_type = NULL;
	}
	
	// Sprawdź identyfikator produktu:
	$pid = (filter_var($pid, FILTER_VALIDATE_INT, array('min_range' => 1))) ? $pid : NULL;
	
	// Zwróć wartość:
	return array($sp_type, $pid);

} // Koniec funkcji parse_sku().

// Funkcja obsliczająca koszty dostawy i obsługi zamówienia.
// Przyjmuje jeden argument: całkowitą wartość zamówienia.
// Zwraca liczbę zmiennoprzecinkową.
function get_shipping($total = 0) {
	
	// Ustal koszt bazowy:
	$shipping = 3;
	
	// Zmień w zależności od wartości zamówienia:
	if ($total < 10) {
		$rate = .25;
	} elseif ($total < 20) {
		$rate = .20;
	} elseif ($total < 50) {
		$rate = .18;
	} elseif ($total < 100) {
		$rate = .16;
	} else {
		$rate = .15;
	}
	
	// Oblicz całkowity koszt dostawy:
	$shipping = $shipping + ($total * $rate);

	// Zwróć całkowity koszt dostawy:
	return number_format($shipping, 2);
	
} // Koniec funkcji get_shipping().
