<?php

// Skrypt umożliwia administratorowi przeglądanie zamówień.
// The administrator can also mark order items as shipped.
// Skrypt jest tworzony w rozdziale 11.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na obsługę błędów.
require ('../includes/config.inc.php');

// Ustaw tytuł strony i dołącz plik nagłówka:
$page_title = 'View An Order';
include ('./includes/header.html');
// W pliku nagłówka jest rozpoczynana sesja.

// Sprawdź identyfikator zamówienia:
$order_id = false;
if (isset($_GET['oid']) && (filter_var($_GET['oid'], FILTER_VALIDATE_INT, array('min_range' => 1))) ) { // Pierwszy raz
	$order_id = $_GET['oid'];
	$_SESSION['order_id'] = $order_id;
} elseif (isset($_SESSION['order_id']) && (filter_var($_SESSION['order_id'], FILTER_VALIDATE_INT, array('min_range' => 1))) ) {
	$order_id = $_SESSION['order_id'];
}

// Zatrzymaj, jeśli nie ma $order_id:
if (!$order_id) {
	echo '<h3>Błąd!</h3><p>Nie można wyświetlić strony.</p>';
	include ('./includes/footer.html');
	exit();
}

// Dołącz plik odpowiedzialny za połączenie z bazą danych:
require(MYSQL);

// ------------------------
// Przetwórz płatność!

// Czy formularz został przesłany?:
if ($_SERVER['REQUEST_METHOD'] == 'POST') {	
	
	// Trezba przetworzyć zamówienie, zapisać transakcję, zaktualizować tabelę order_contents i zmodyfikować stan magazynowy.
	
	// Pobierz informacje o zamówieniu:
	$q = "SELECT customer_id, total, transaction_id FROM orders AS o JOIN transactions AS t ON (o.id=t.order_id AND t.type='AUTH_ONLY' AND t.response_code=1) WHERE o.id=$order_id";
	$r = mysqli_query($dbc, $q);
	
	if (mysqli_num_rows($r) == 1) {
		
		// Pobierz zwracane wartości:
		list($customer_id, $order_total, $trans_id) = mysqli_fetch_array($r, MYSQL_NUM);
		
		// Sprawdź, czy całkowita wartość jest dodatnia:
		if ($order_total > 0) {
			
			// Wyślij żądanie do bramki płatniczej:
			require_once(BASE_URI . 'private/gateway_setup_admin.php');
			require_once(BASE_URI . 'private/gateway_process.php');
			
			// Dodaj ukośniki do dwóch wartości tekstowych:
			$reason = addslashes($response_array[3]);
			$response = addslashes($response);

			// Zapisz transakcję:
			$r = mysqli_query($dbc, "CALL add_transaction($order_id, '{$data['x_type']}', $response_array[9], $response_array[0], '$reason', $response_array[6], '$response')");				
			
			// Jeśli zakończyło się powodzeniem, zaktualizuj zamówienie i stan magazynowy:
			if ($response_array[0] == 1) {
				
				$message = 'Płatność zrealizowana. Możesz dostarczyć zamówienie.';
					
				// Zaktualizuj tabelę order_contents:
				$q = "UPDATE order_contents SET ship_date=NOW() WHERE order_id=$order_id";
				$r = mysqli_query($dbc, $q);
	
				// Zaktualizuj stan magazynowy...
				$q = 'UPDATE specific_coffees AS sc, order_contents AS oc SET sc.stock=sc.stock-oc.quantity WHERE sc.id=oc.product_id AND oc.product_type="coffee" AND oc.order_id=' . $order_id;
				$r = mysqli_query($dbc, $q);
				$q = 'UPDATE non_coffee_products AS ncp, order_contents AS oc SET ncp.stock=ncp.stock-oc.quantity WHERE ncp.id=oc.product_id AND oc.product_type="other" AND oc.order_id=' . $order_id;
				$r = mysqli_query($dbc, $q);
								
			} else { // W zależności od odpowiedzi wykonaj różne akcje:
				
				$error = "Płatność nie może zostać zrealizowana: $response_array[3]";
			
			} // Koniec instrukcji IF-ELSE odpowiedzi.

		} else { // Niewłaściwa wartość całkowita!

				$error = "Wartość zamówienia (\$$order_total) jest niepoprawna.";

		} // Koniec instrukcji IF-ELSE $order_total.

	} else { // Brak zamówienia!
		
		$error = 'Brak wskazanego zamówienia.';
		
	} // Koniec instrukcji IF-ELSE identyfikatora transakcji
	
	// Raportuj komunikaty i błędy:
	echo '<h3>Raport zamówienia</h3>';
	if (isset($message)) echo "<p>$message</p>";
	if (isset($error)) echo "<p class=\"error\">$error</p>";

} // Koniec instrukcji IF formularza.

// Powyższy kod został dodany w trakcie pracy nad realizacją procesu płatności.
// ------------------------

// Zdefiniuj kwerendę:
$q = 'SELECT total, shipping, credit_card_number, DATE_FORMAT(order_date, "%a %b %e, %Y at %h:%i%p") AS od, email, CONCAT(last_name, ", ", first_name) AS name, CONCAT_WS(" ", address1, address2, city, state, zip) AS address, phone, customer_id, CONCAT_WS(" - ", ncc.category, ncp.name) AS item, ncp.stock, quantity, price_per, DATE_FORMAT(ship_date, "%b %e, %Y") AS sd FROM orders AS o INNER JOIN customers AS c ON (o.customer_id = c.id) INNER JOIN order_contents AS oc ON (oc.order_id = o.id) INNER JOIN non_coffee_products AS ncp ON (oc.product_id = ncp.id AND oc.product_type="other") INNER JOIN non_coffee_categories AS ncc ON (ncc.id = ncp.non_coffee_category_id) WHERE o.id=' . $order_id . '
UNION 
SELECT total, shipping, credit_card_number, DATE_FORMAT(order_date, "%a %b %e, %Y at %l:%i%p"), email, CONCAT(last_name, ", ", first_name), CONCAT_WS(" ", address1, address2, city, state, zip), phone, customer_id, CONCAT_WS(" - ", gc.category, s.size, sc.caf_decaf, sc.ground_whole) AS item, sc.stock, quantity, price_per, DATE_FORMAT(ship_date, "%b %e, %Y") FROM orders AS o INNER JOIN customers AS c ON (o.customer_id = c.id) INNER JOIN order_contents AS oc ON (oc.order_id = o.id) INNER JOIN specific_coffees AS sc ON (oc.product_id = sc.id AND oc.product_type="coffee") INNER JOIN sizes AS s ON (s.id=sc.size_id) INNER JOIN general_coffees AS gc ON (gc.id=sc.general_coffee_id) WHERE o.id=' . $order_id;

// Wykonaj kwerendę:
$r = mysqli_query($dbc, $q);
if (mysqli_num_rows($r) > 0) { // Wyświetl informację o zamówieniu:

	echo '<h3>Zamówienie</h3>
	<form action="view_order.php" method="post" accept-charset="utf-8">
		<fieldset>';
		
	// Pobierz pierwszy wiersz:
	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);
	
	// Wyświetl informacje o zamówieniu i kliencie:
	echo "<p><strong>Identyfikator zamówienia</strong>: $order_id<br /><strong>Wartość całkowita</strong>: \${$row['total']}<br /><strong>Koszt dostawy</strong>: \${$row['shipping']}<br /><strong>Data dostawy</strong>: {$row['od']}<br /><strong>Klient</strong>: {$row['name']}<br /><strong>Adres</strong>: {$row['address']} <br /><strong>E-mail</strong>: {$row['email']}<br /><strong>Nr telefonu</strong>: {$row['phone']}<br /><strong>Numer karty kredytowej</strong>: *{$row['credit_card_number']}</p>";
	
	// Utwórz tabelę:
	echo '<table border="0" width="100%" cellspacing="8" cellpadding="6">
	<thead>
		<tr>
	    <th align="center">Produkt</th>
	    <th align="right">Cena</th>
	    <th align="center">Stan magazynowy</th>
	    <th align="center">Ilość zamówiona</th>
	    <th align="center">Dostarczony?</th>
	  </tr>
	</thead>
	<tbody>';
	
	// Na potrzeby potwierdzenia, że zamówienie zostało zrealizowane:
	$shipped = true;
	
	// Wyświetl wszystkie pozycje:
	do {
		
		// Utwórz wiersz tabeli:
		echo '<tr>
		    <th align="left">' . $row['item'] . '</th>
		    <th align="right">' . $row['price_per'] . '</th>
		    <th align="center">' . $row['stock'] . '</th>
		    <th align="center">' . $row['quantity'] . '</th>
		    <th align="center">' . $row['sd'] . '</td>
		</tr>';
		
		if (!$row['sd']) $shipped = false;
						
	} while ($row = mysqli_fetch_array($r));
	
	// Zakońćz kod tabeli:
	echo '</tbody></table>';
	
	// Wyświetl przycisk, jeśli zamówienie nie zostało zrealizowane:
	if (!$shipped) {
		echo '<div class="field"><p class="error">Płatność zostanie zrealizowana po klinknięciu przycisku!</p><input type="submit" value="Dostarcz zamówienie" class="button" /></div>';	
	}
		
	// Zakończ kod formularza:
	echo '</fieldset>
	</form>';

} else { // Brak rekordów!
	echo '<h3>Błąd!</h3><p>Nie udało się wyświetlić tej strony.</p>';
	include ('./includes/footer.html');
	exit();	
}

include ('./includes/footer.html');
?>
