<?php

// Plik zawiera stałe wymagane podczas łączenia się z bazą danych.
// W pliku jest ustanawiane połączenie z bazą MySQL i wybierana baza danych.
// W pliku jest zdefiniowana funkcja czyszcząca dane na potrzeby kwerend.
// W pliku jest zdefiniowana funkcja haszująca hasło.
// Tworzenie skryptu rozpoczyna się w rozdziale 3. 

// Zdefiniuj stałe zawierające dane potrzebne podczas łączenia się z bazą danych:
DEFINE ('DB_USER', 'username');
DEFINE ('DB_PASSWORD', 'password');
DEFINE ('DB_HOST', 'localhost');
DEFINE ('DB_NAME', 'ecommerce1');

// Nawiąż połączenie:
$dbc = mysqli_connect (DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);

// Ustaw kodowanie znaków:
mysqli_set_charset($dbc, 'utf8');

// Funkcja czyszcząca dane z formularza
// Przyjmuje jeden argument: dane w postaci łańcucha znaków
// Zwraca oczyszczone dane w postaci łańcucha znaków
function escape_data ($data) { 

	global $dbc; // Połączenie z bazą danych.
	
	// Usuń ukośniki, jeśli mechanizm Magic Quotes jest włączony:
	if (get_magic_quotes_gpc()) $data = stripslashes($data);
	
	// Zastosuj funkcje trim() i mysqli_real_escape_string():
	return mysqli_real_escape_string (trim ($data), $dbc);
	
} // Koniec funkcji escape_data().

// Ten blok kodu jest dodawany w rozdziale 4.

// Funkcja zwraca zahaszowane hasło.
// Przyjmuje jeden argument: hasło użytkownika.
// Zwraca binarną wersję hasła, sformatowaną tak, by można jej było użyć w kwerendach.
function get_password_hash($password) {
	
	// Wymagane połączenie z bazą danych:
	global $dbc;
	
	// Zwróć zahaszowane i oczyszczone hasło:
	return mysqli_real_escape_string ($dbc, hash_hmac('sha256', $password, 'c#haRl891', true));
	
} // Koniec funkcji get_password_hash().

// Pomiń zamykający znacznik PHP, by uniknąć błędów spowodowanych wielokrotnym przesyłaniem nagłówków ('headers already sent')!
