<?php

// Skrypt usuwa stronę z zawartością z listy ulubionych.
// To jest dodatkowy materiał zasygnalizowany w rozdziale 5.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na funkcję obsługi błędów:
require ('./includes/config.inc.php');
// W pliku jest również rozpoczynana sesja.

// Jeśli użytkownik nie ma aktywnego konta, przekieruj go:
redirect_invalid_user('user_not_expired');

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require(MYSQL);

// Sprawdź identyfikator kategorii:
if (filter_var($_GET['id'], FILTER_VALIDATE_INT, array('min_range' => 1))) {

	// Pobierz informacje o stronie:
	$q = 'SELECT title, description, content FROM pages WHERE id=' . $_GET['id'];
	$r = mysqli_query($dbc, $q);
	if (mysqli_num_rows($r) != 1) { // Problem!
		$page_title = 'Błąd!';
		include ('./includes/header.html');
		echo '<p class="error">Problem z dostępem do strony.</p>';
		include ('./includes/footer.html');
		exit();
	}
	
	// Pobierz informacje o stronie:
	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);
	$page_title = $row['title'];
	include ('includes/header.html');
	echo "<h3>$page_title</h3>";
	
	// Dodaj pozycję do bazy danych:
	$q = 'DELETE FROM favorite_pages WHERE user_id=' . $_SESSION['user_id'] . ' AND page_id=' . $_GET['id'] . ' LIMIT 1';
	$r = mysqli_query($dbc, $q);
	if (mysqli_affected_rows($dbc) == 1) {
		echo '<p>Strona została usunięta z ulubionych! <img src="/images/cross_48.png" border="0" width="48" height="48" align="middle" /></p>';
	} else {
		trigger_error('Błąd systemu. Przepraszamy za utrudnienia.');
	}

	// Wyświetl zawartość strony:
	echo "<div>{$row['content']}</div>";
		
} else { // Brak poprawnego identyfikatora.
	$page_title = 'Błąd!';
	include ('includes/header.html');
	echo '<p class="error">Problem z dostępem do strony.</p>';
} // Koniec głównej instrukcji IF.

// Dołącz stopkę:
include ('./includes/footer.html');
?>
