<?php 

// Skrypt wyświetlający stronę logowania.
// Jest dołączany przez plik index.php, który otrzymuje dane z formularza logowania.
// Skrypt jest tworzony w rozdziale 4.

// Tablica przechowująca błędy:
$login_errors = array();

// Sprawdź poprawność adresu e-mailowego:
if (filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
	$e = mysqli_real_escape_string ($dbc, $_POST['email']);
} else {
	$login_errors['email'] = 'Wpisz poprawny adres e-mail!';
}

// Sprawdź poprawność hasła:
if (!empty($_POST['pass'])) {
	$p = mysqli_real_escape_string ($dbc, $_POST['pass']);
} else {
	$login_errors['pass'] = 'Wpisz hasło!';
}
	
if (empty($login_errors)) { // Można kontynuować!

	// Zapytanie do bazy danych:
	$q = "SELECT id, username, type, IF(date_expires >= NOW(), true, false) FROM users WHERE (email='$e' AND pass='"  .  get_password_hash($p) .  "')";		
	$r = mysqli_query ($dbc, $q);
	
	if (mysqli_num_rows($r) == 1) { // Zgadza się.
		
		// Pobierz dane:
		$row = mysqli_fetch_array ($r, MYSQLI_NUM); 
		
		// Jeśli użytkownik jest administratorem, utwórz nowy identyfikator sesji:
		// Ten kod jest dodawany pod koniec rozdziału 4.:
		if ($row[2] == 'admin') {
			session_regenerate_id(true);
			$_SESSION['user_admin'] = true;
		}
		
		// Zapisz dane w sesji:
		$_SESSION['user_id'] = $row[0];
		$_SESSION['username'] = $row[1];
		
		// Ustaw tylko wtedy, gdy konto użytkownika nie wygasło:
		if ($row[3] == 1) $_SESSION['user_not_expired'] = true;
			
	} else { // Nie zgadza się.
		$login_errors['login'] = 'Niewłaściwy adres e-mail lub hasło.';
	}
	
} // Koniec instrukcji IF $login_errors.

// Pomiń zamykający znacznik PHP, by uniknąć błędów 'headers already sent'!
