<?php

// Skrypt wyświetlający historię przeglądania użytkownika.
// To jest dodatkowy materiał zasygnalizowany w rozdziale 5.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na funkcję obsługi błędów:
require ('./includes/config.inc.php');
// W pliku jest również rozpoczynana sesja.

// Jeśli użytkownik nie jest zalogowany, przekieruj go:
redirect_invalid_user();

// Dołącz plik nagłówka:
$page_title = 'Historia przeglądania';
include ('./includes/header.html');

echo '<h3>Historia przeglądania</h3>';

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require (MYSQL);

// Pobierz informację o stronie:
//$q = 'SELECT id, title, description, IF(favorite_pages.user_id=' . $_SESSION['user_id'] .', true, false) FROM pages LEFT JOIN favorite_pages ON (pages.id=favorite_pages.page_id) ORDER BY title';

// Pobierz przeglądane strony
$q = 'SELECT pages.id, title, description, DATE_FORMAT(history.date_created, "%M %d, %Y") FROM pages LEFT JOIN history ON (pages.id=history.page_id) WHERE history.user_id=' . $_SESSION['user_id'] . ' GROUP BY (history.page_id) ORDER BY history.date_created DESC';
$r = mysqli_query($dbc, $q);

echo '<h4>Strony, które przeglądałeś</h4>';

if (mysqli_num_rows($r) > 0) {
	
	while ($row = mysqli_fetch_array($r, MYSQLI_NUM)) {
		// Wyświetl wszystkie rekordy:
		echo "<div><h4><a href=\"page.php?id=$row[0]\">$row[1]</a></h4><p>$row[2]<br />Ostatnio przeglądane: $row[3]</p></div>\n";
	}

} else { // Brak stron.
	echo '<p>Nie przeglądałeś jeszcze żadnej strony.</p>';
}

// Pobierz przeglądane pliki PDF
$q = 'SELECT pdfs.tmp_name, title, description, DATE_FORMAT(history.date_created, "%M %d, %Y") FROM pdfs LEFT JOIN history ON (pdfs.id=history.pdf_id) WHERE history.user_id=' . $_SESSION['user_id'] . ' GROUP BY (history.pdf_id) ORDER BY history.date_created DESC';
$r = mysqli_query($dbc, $q);

echo '<h4>Przeglądane pliki PDF</h4>';

if (mysqli_num_rows($r) > 0) {
	
	while ($row = mysqli_fetch_array($r, MYSQLI_NUM)) {
		// Wyświetl wszystkie rekordy:
		echo "<div><h4><a href=\"view_pdf.php?id=$row[0]\">$row[1]</a></h4><p>$row[2]<br />Ostatnio przeglądane: $row[3]</p></div>\n";
	}

} else { // Brak plików.
	echo '<p>Nie przeglądałeś żadnych plików PDF.</p>';
}

// Dołącz stopkę:
include ('./includes/footer.html');
?>
