<?php

// Skrypt służy do resetowania zapomnianego hasła.
// Generowane jest nowe hasło, które zostaje przesłane e-mailem.
// Skrypt jest tworzony w rozdziale 4.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na funkcję obsługi błędów:
require ('./includes/config.inc.php');
// W pliku jest również rozpoczynana sesja.

// Dołącz nagłówek:
$page_title = 'Nie pamiętasz hasła?';
include ('./includes/header.html');

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require (MYSQL);

// Tablica błędów:
$pass_errors = array();

// Jeśli to żądanie POST, obsłuż formularz:
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

	// Sprawdź poprawność adresu e-mailowego
	if (filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
	
		// Sprawdź, czy adres e-mailowy istnieje...
		$q = 'SELECT id FROM users WHERE email="'.  mysqli_real_escape_string ($dbc, $_POST['email']) . '"';
		$r = mysqli_query ($dbc, $q);
		
		if (mysqli_num_rows($r) == 1) { // Pobierz identyfikator użytkownika.
			list($uid) = mysqli_fetch_array ($r, MYSQLI_NUM); 
		} else { // Brak użytkownika o podanym adresie e-mailowym.
			$pass_errors['email'] = 'Podany adres e-mail nie jest zarejstrowany w bazie danych!';
		}
		
	} else { // Podany adres nie jest prawidłowy.
		$pass_errors['email'] = 'Wpisz poprawny adres e-mailowy!';
	} // // Koniec instrukcji warunkowej IF $_POST['email'].
	
	if (empty($pass_errors)) { // Jeśli wszystko się zgadza.

		// Utwórz nowe, losowe hasło:
		$p = substr(md5(uniqid(rand(), true)), 15, 15);

		// Zaktualizuj bazę danych:
		$q = "UPDATE users SET pass='" .  get_password_hash($p) . "' WHERE id=$uid LIMIT 1";
		$r = mysqli_query ($dbc, $q);
		
		if (mysqli_affected_rows($dbc) == 1) { // Jeśli operacja została wykonana prawidłowo.
		
			// Wyślij e-mail:
			$body = "Hasło wymagane do zalogowania się na naszej witrynie zostało tymczasowo zmienione na '$p'. Zaloguj się, podając to hasło i adres e-mailowy. Po zalogowaniu hasło możesz zmienić.";
			mail ($_POST['email'], 'Tymczasowe hasło', $body, 'From: admin@example.com');
			
			// Wyświetl komunikat i zakończ stronę:
			echo '<h3>Twoje hasło zostało zmienione.</h3><p>Na Twoją skrzynkę mailową przyjdzie wiadomość z tymczasowym hasłem. Po zalogowaniu się w witrynie za pomocą nowego hasła, możesz je zmienić, klikając link "Zmień hasło".</p>';
			include ('./includes/footer.html');
			exit(); // Zatrzymaj skrypt.
			
		} else { // Jeśli nie udało się zaktualizować bazy.
	
			trigger_error('Hasło nie może zostać zmienione z powodu błędu systemu. Przepraszamy za kłopot.'); 

		}

	} // Koniec IF $uid.

} // Koniec głównego warunku formularza.

// Wymagany skrypt z funkcją create_form_input():
require ('./includes/form_functions.inc.php');
?><h3>Odnawianie hasła</h3>
<p>Wpisz swój adres e-mailowy, aby odnowić hasło.</p> 
<form action="forgot_password.php" method="post" accept-charset="utf-8">
	<p><label for="email"><strong>Adres e-mailowy</strong></label><br /><?php create_form_input('email', 'text', $pass_errors); ?></p>
	<input type="submit" name="submit_button" value="Odnów &rarr;" id="submit_button" class="formbutton" />
</form>

<?php // Dołącz plik stopki:
include ('./includes/footer.html');
?>
