<?php

// Skrypt jest używany przez administratora do dodawania pliku PDF do witryny.
// Skrypt jest tworzony w rozdziale 5.

// Dołącz plik konfiguracyjny przed jakimkolwiek kodem PHP, ponieważ znajduje się w nim funkcja obsługi błędów:
require ('./includes/config.inc.php');

// Jeśli użytkownik nie jest zalogowany jako administrator, przekieruj go:
redirect_invalid_user('user_admin');

// Dołącz plik nagłówka:
$page_title = 'Dodaj plik PDF';
include ('./includes/header.html');

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require(MYSQL);

// Tablica przechowująca błędy:
$add_pdf_errors = array();

// Sprawdź, czy formularz został przesłany:
if ($_SERVER['REQUEST_METHOD'] == 'POST') {	

	// Sprawdź tytuł:
	if (!empty($_POST['title'])) {
		$t = mysqli_real_escape_string($dbc, strip_tags($_POST['title']));
	} else {
		$add_pdf_errors['title'] = 'Wpisz tytuł!';
	}
	
	// Sprawdź opis:
	if (!empty($_POST['description'])) {
		$d = mysqli_real_escape_string($dbc, strip_tags($_POST['description']));
	} else {
		$add_pdf_errors['description'] = 'Wpisz opis!';
	}

	// Sprawdź plik PDF:
	if (is_uploaded_file ($_FILES['pdf']['tmp_name']) && ($_FILES['pdf']['error'] == UPLOAD_ERR_OK)) {
		
		$file = $_FILES['pdf'];
		
		$size = ROUND($file['size']/1024);

		// Sprawdź rozmiar pliku:
		if ($size > 1024) {
			$add_pdf_errors['pdf'] = 'Wybrany plik jest za duży.';
		} 

		// Sprawdź typ pliku:
		if ( ($file['type'] != 'application/pdf') && (substr($file['name'], -4) != '.pdf') ) {
			$add_pdf_errors['pdf'] = 'Wybrany plik nie jest dokumentem PDF.';
		} 
		
		// Przenieś plik, jeśli nie wystąpiły problemy:
		if (!array_key_exists('pdf', $add_pdf_errors)) {

			// Utwórz tymczasową nazwę dla pliku:
			$tmp_name = sha1($file['name'] . uniqid('',true));
			
			// Przenieś plik do prawidłowego katalogu, ale do nazwy na wszelki wypadek dodaj _tmp:
			$dest =  PDFS_DIR . $tmp_name . '_tmp';

			if (move_uploaded_file($file['tmp_name'], $dest)) {
				
				// Zapisz dane w sesji, by były dostępne później:
				$_SESSION['pdf']['tmp_name'] = $tmp_name;
				$_SESSION['pdf']['size'] = $size;
				$_SESSION['pdf']['file_name'] = $file['name'];
				
				// Wypisz komunikat:
				echo '<h4>Plik został przesłany!</h4>';
				
			} else {
				trigger_error('Plik nie może zostać przeniesiony.');
				unlink ($file['tmp_name']);				
			}

		} // // Koniec instrukcji warunkowej IF array_key_exists().
		
	} elseif (!isset($_SESSION['pdf'])) { // No current or previous uploaded file.
		switch ($_FILES['pdf']['error']) {
			case 1:
			case 2:
				$add_pdf_errors['pdf'] = 'Wybrany plik jest za duży.';
				break;
			case 3:
				$add_pdf_errors['pdf'] = 'Plik nie został pobrany w całości.';
				break;
			case 6:
			case 7:
			case 8:
				$add_pdf_errors['pdf'] = 'Plik nie może zostać przesłany z powodu błędu systemu.';
				break;
			case 4:
			default: 
				$add_pdf_errors['pdf'] = 'Żaden plik nie został przesłany.';
				break;
		} // Koniec instrukcji SWITCH.

	} // Koniec instrukcji IF-ELSEIF-ELSE dla $_FILES.
	
	if (empty($add_pdf_errors)) { // If everything's OK.
		
		// Dodaj PDF do bazy danych:
		$fn = mysqli_real_escape_string($dbc, $_SESSION['pdf']['file_name']);
		$tmp_name = mysqli_real_escape_string($dbc, $_SESSION['pdf']['tmp_name']);
		$size = (int) $_SESSION['pdf']['size'];
		$q = "INSERT INTO pdfs (tmp_name, title, description, file_name, size) VALUES ('$tmp_name', '$t', '$d', '$fn', $size)";
		$r = mysqli_query ($dbc, $q);
		if (mysqli_affected_rows($dbc) == 1) { // Jeśli OK.
			
			// Zmień nazwę tymczasowego pliku:
			$original =  PDFS_DIR . $tmp_name . '_tmp';
			$dest =  PDFS_DIR . $tmp_name;
			rename($original, $dest);

			// Wyświetl komunikat:
			echo '<h4>Plik PDF został dodany!</h4>';
		
			// Wyczyść tablicę $_POST:
			$_POST = array();
			
			// Wyczyść tablicę $_FILES:
			$_FILES = array();
			
			// Wyczyść $file i $_SESSION['pdf']:
			unset($file, $_SESSION['pdf']);
					
		} else { // Jeśli pojawiły się problemy.
			trigger_error('Pliku PDF nie udało się dodać do bazy danych z powodu błędu systemu. Przepraszamy za kłopot.');
			unlink ($dest);
		}
				
	} // Koniec instrukcji warunkowej IF $errors.
	
} else { // Wyczyść zmienne sesji żądania GET:
	unset($_SESSION['pdf']);	
} // // Koniec instrukcji warunkowej IF sprawdzającej przesłanie pliku.

// Dołączenie skryptu z funkcjami ze względu na funkcję create_form_input():
require ('includes/form_functions.inc.php');
?><h3>Dodaj plik PDF</h3>
<form enctype="multipart/form-data" action="add_pdf.php" method="post" accept-charset="utf-8">

	<input type="hidden" name="MAX_FILE_SIZE" value="1048576" />
	
	<fieldset><legend>Aby przesłać plik PDF, wypełnij wszystkie pola:</legend>
	
		<p><label for="title"><strong>Tytuł</strong></label><br /><?php create_form_input('title', 'text', $add_pdf_errors); ?></p>
	
		<p><label for="description"><strong>Opis</strong></label><br /><?php create_form_input('description', 'textarea', $add_pdf_errors); ?></p>

		<p><label for="pdf"><strong>Plik PDF</strong></label><br /><?php echo '<input type="file" name="pdf" id="pdf"';
		
			// Sprawdź, czy wystąpił jakiś błąd:
			if (array_key_exists('pdf', $add_pdf_errors)) {
				
				echo ' class="error" /> <span class="error">' . $add_pdf_errors['pdf'] . '</span>';
				
			} else { // Brak błędów.

				echo ' />';

				// Jeśli plik istnieje (from a previous form submission but there were other errors),
				// store the file info in a session and note its existence:		
				if (isset($_SESSION['pdf'])) {
					echo " Aktualnie przesłany plik: '{$_SESSION['pdf']['file_name']}'";
				}

			} // koniec instrukcji warunkowej IF-ELSE sprawdzającej błędy.
		 ?> <small>Tylko dokumenty PDF o maksymalnym rozmiarze 1MB</small></p>

	<p><input type="submit" name="submit_button" value="Dodaj plik PDF" id="submit_button" class="formbutton" /></p>
	
	
	</fieldset>

</form> 

<?php // Dołącz plik HTML stopki:
include ('./includes/footer.html');
?>
