<?php

// Skrypt odpowiada za pierwszy krok procesu finalizowania zamówienia.
// Pobiera i sprawdza dane do wysyłki.
// Praca nad skryptem rozpoczyna się w rozdziale 10.

// Dołącz plik konfiguracyjny przed kodem PHP:
require ('./includes/config.inc.php');

// Sprawdź identyfikator sesji, aby pobrać zawartość koszyka:
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
	if (isset($_GET['session'])) {
		$uid = $_GET['session'];
		// Skorzystaj z istniejącego identyfikatora użytkownika:
		session_id($uid);
		// Rozpocznij sesję:
		session_start();
	} else { // Przekieruj użytkownika.
		$location = 'http://' . BASE_URL . 'cart.php';
		header("Location: $location");
		exit();
	}
} else { // żądanie POST.
	session_start();
	$uid = session_id();
}

// Utwórz sesję na potrzeby procesu finalizowania zamówienia...

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require (MYSQL);

// Sprawdź formularz...

// Tablica błędów:
$shipping_errors = array();

// Sprawdź, czy formularz został przesłany:
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

	// Sprawdź, czy mechanizm Magic Quotes jest włączony:
	if (get_magic_quotes_gpc()) {
		$_POST['first_name'] = stripslashes($_POST['first_name']);
		// Powtórz dla wszystkich zmiennych, które tego wymagają.
	}

	// Sprawdź pole imienia:
	if (preg_match ('/^[A-ZąćęłńóśżźĄĆĘŁŃÓŚŻŹ \'.-]{2,20}$/i', $_POST['first_name'])) {
		$fn = addslashes($_POST['first_name']);
	} else {
		$shipping_errors['first_name'] = 'Wpisz imię!';
	}
	
	// Sprawdź pole nazwiska:
	if (preg_match ('/^[A-ZąćęłńóśżźĄĆĘŁŃÓŚŻŹ \'.-]{2,40}$/i', $_POST['last_name'])) {
		$ln  = addslashes($_POST['last_name']);
	} else {
		$shipping_errors['last_name'] = 'Wpisz nazwisko!';
	}
	
	// Sprawdź pole adresu - ulica:
	if (preg_match ('/^[A-ZąćęłńóśżźĄĆĘŁŃÓŚŻŹ0-9 \',.#-]{2,80}$/i', $_POST['address1'])) {
		$a1  = addslashes($_POST['address1']);
	} else {
		$shipping_errors['address1'] = 'Podaj nazwę ulicy!';
	}
	
	// Sprawdź pole adresu - ulica (2):
	if (empty($_POST['address2'])) {
		$a2 = NULL;
	} elseif (preg_match ('/^[A-ZąćęłńóśżźĄĆĘŁŃÓŚŻŹ0-9 \',.#-]{2,80}$/i', $_POST['address2'])) {
		$a2 = addslashes($_POST['address2']);
	} else {
		$shipping_errors['address2'] = 'Podaj nazwę ulicy!';
	}
	
	// Sprawdź pole miasta:
	if (preg_match ('/^[A-ZąćęłńóśżźĄĆĘŁŃÓŚŻŹ \'.-]{2,60}$/i', $_POST['city'])) {
		$c = addslashes($_POST['city']);
	} else {
		$shipping_errors['city'] = 'Podaj nazwę miasta!';
	}
	
	// Sprawdź pole województwa:
	if (preg_match ('/^[A-ZąćęłńóśżźĄĆĘŁŃÓŚŻŹ]{2}$/', $_POST['state'])) {
		$s = $_POST['state'];
	} else {
		$shipping_errors['state'] = 'Podaj nazwę województwa!';
	}
	
	// Check for a zip code:
	if (preg_match ('/^(^\d{2}-\d{3})$/', $_POST['zip'])) {
		$z = $_POST['zip'];
	} else {
		$shipping_errors['zip'] = 'Podaj kod pocztowy!';
	}
	
	// Sprawdź numer telefonu:
	// Usuń spacje, łączniki i nawiasy okrągłe:
	$phone = str_replace(array(' ', '-', '(', ')'), '', $_POST['phone']);
	if (preg_match ('/^[0-9]{10}$/', $phone)) {
		$p  = $phone;
	} else {
		$shipping_errors['phone'] = 'Wpisz numer telefonu!';
	}
	
	// Sprawdź adres e-mailowy:
	if (filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
		$e = $_POST['email'];
		$_SESSION['email'] = $_POST['email'];
	} else {
		$shipping_errors['email'] = 'Wpisz poprawny e-mail!';
	}
	
	// Sprawdź, czy adres kupującego jest taki sam, jak adres dostawy:
	if (isset($_POST['use']) && ($_POST['use'] == 'Y')) {
		$_SESSION['shipping_for_billing'] = true;
		$_SESSION['cc_first_name']  = $_POST['first_name'];
		$_SESSION['cc_last_name']  = $_POST['last_name'];
		$_SESSION['cc_address']  = $_POST['address1'] . ' ' . $_POST['address2'];
		$_SESSION['cc_city'] = $_POST['city'];
		$_SESSION['cc_state'] = $_POST['state'];
		$_SESSION['cc_zip'] = $_POST['zip'];
	}

	if (empty($shipping_errors)) { // Jeśli wszystko w porządku...
		
		// Dodaj użytkownika do bazy danych...
		
		// Wywołaj procerdurę składowaną:
		$r = mysqli_query($dbc, "CALL add_customer('$e', '$fn', '$ln', '$a1', '$a2', '$c', '$s', $z, $p, @cid)");

		// Sprawdź, czy działa:
		if ($r) {
		
			// Pobierz identyfikator użytkownika:
			$r = mysqli_query($dbc, 'SELECT @cid');
			if (mysqli_num_rows($r) == 1) {

				list($_SESSION['customer_id']) = mysqli_fetch_array($r);
					
				// Przekieruj do kolejnej strony:
				$location = 'https://' . BASE_URL . 'billing.php';
				header("Location: $location");
				exit();

			}

		}

		// Błędy do loga i na e-maila. Panika!

		trigger_error('Zamówienie nie może zostać przetworzone z powodu błędu systemu. Przepraszamy za niedogodności.');

	} // Koniec instrukcji IF błędu.

} // Koniec instrukcji IF REQUEST_METHOD.
							
// Dołącz plik nagłówka:
$page_title = 'Kawy świata - zamówienie - informacje o wysyłce';
include ('./includes/checkout_header.html');

// Pobierz zawartość koszyka:
$r = mysqli_query($dbc, "CALL get_shopping_cart_contents('$uid')");

if (mysqli_num_rows($r) > 0) { // Wyświetl produkty!
	include ('./views/checkout.html');
} else { // Pusty koszyk!
	include ('./views/emptycart.html');
}

// Dołącz plik stopki:
include ('./includes/footer.html');
?>
