<?php

// Skrypt zarządza koszykiem na zakupy.
// Praca nad skryptem rozpoczyna się w rozdziale 9.

// Dołącz plik konfiguracyjny przed kodem PHP:
require ('./includes/config.inc.php');

// Poszukaj lub utwórz sesję użytkownika:
if (isset($_COOKIE['SESSION'])) {
	$uid = $_COOKIE['SESSION'];
} else {
	$uid = md5(uniqid('biped',true));
}

// Wyślij ciasteczko:
setcookie('SESSION', $uid, time()+(60*60*24*30));

// Dołącz plik nagłówka:
$page_title = 'Coffee - Your Shopping Cart';
include ('./includes/header.html');

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require (MYSQL);

// Dołącz funkcje pomocnicze:
include ('./includes/product_functions.inc.php');

// Jeśli w URL-u znajduje się SKU, rozdziel ją na części:
if (isset($_GET['sku'])) {
	list($sp_type, $pid) = parse_sku($_GET['sku']);
}

if (isset ($pid, $sp_type, $_GET['action']) && ($_GET['action'] == 'add') ) { // Dodaj nowy produkt do koszyka:

	$r = mysqli_query($dbc, "CALL add_to_cart('$uid', '$sp_type', $pid, 1)");
	
	// Na potrzeby debugowania:
	//if (!$r) echo mysqli_error($dbc);
		
} elseif (isset ($sp_type, $pid, $_GET['action']) && ($_GET['action'] == 'remove') ) { // Usuń produkt z koszyka.
	
	$r = mysqli_query($dbc, "CALL remove_from_cart('$uid', '$sp_type', $pid)");

} elseif (isset ($sp_type, $pid, $_GET['action'], $_GET['qty']) && ($_GET['action'] == 'move') ) { // Przenieś do koszyka.

	// Określ ilość:
	$qty = (filter_var($_GET['qty'], FILTER_VALIDATE_INT, array('min_range' => 1))) ? $_GET['qty'] : 1;
	
	// Dodaj do koszyka:
	$r = mysqli_query($dbc, "CALL add_to_cart('$uid', '$sp_type', $pid, $qty)");
	
	// Usuń z przechowalni:
	$r = mysqli_query($dbc, "CALL remove_from_wish_list('$uid', '$sp_type', $pid)");

} elseif (isset($_POST['quantity'])) { // Zaktualizuj ilości w koszyku.
	
	// Przejdź przez wszystkie pozycje:
	foreach ($_POST['quantity'] as $sku => $qty) {
		
		// Przetwórz SKU:
		list($sp_type, $pid) = parse_sku($sku);
		
		if (isset($sp_type, $pid)) {

			// Określ ilość:
			$qty = (filter_var($qty, FILTER_VALIDATE_INT, array('min_range' => 0))) ? $qty : 1;

			// ZAktualizuj ilość w koszyku:
			$r = mysqli_query($dbc, "CALL update_cart('$uid', '$sp_type', $pid, $qty)");

		}
			
	} // Koniec pętli FOREACH.
	
}// Koniec głównej instrukcji IF.
		
// Pobierz zawartość koszyka:
$r = mysqli_query($dbc, "CALL get_shopping_cart_contents('$uid')");

if (mysqli_num_rows($r) > 0) { // Wyświetl pozycje koszyka!
	include ('./views/cart.html');
} else { // Pusty koszyk!
	include ('./views/emptycart.html');
}

// Dołącz stopkę.:
include ('./includes/footer.html');
?>
