<?php

/* 

Nazwa pliku: config.inc.php
Autor: Larry E. Ullman z firmy DMC Insights, Inc. 
Kontakt: LarryUllman@DMCInsights.com, http://www.dmcinsights.com

Plik konfiguracyjny odpowiada za następujące sprawy:
- Przechowuje ustawienia witryny w jednym miejscu.
- Przechowuje adresy URL i URI w postaci stałych.
- Zawiera funkcję obsługi błędów.

*** To jest plik konfiguracyjny dla stron administracyjnych. Różni się od pliku konfiguracyjnego witryny. ***

*/

// ********************************** //
// ************ USTAWIENIA ************ //

// E-mail, na który są wysyłane komunikaty o błędach.
$contact_email = 'you@example.com'; 

// Określ lokalizację plików i adresy witryny. Pozwala na tworzenie witryny na różnych serwerach.
// Drugi zestaw stałych jest używany, gdy warunek przyjmie wartość false.
if ($_SERVER['HTTP_HOST']=='localhost') {
	$debug = TRUE;
	define ('BASE_URI', '/path/to/htdocs/folder/');
	define ('BASE_URL',	'http://www.address.com/');
	define ('MYSQL', '/path/to/mysql_connect.inc.php');
} else {
	define ('BASE_URI', '/path/to/htdocs/folder/');
	define ('BASE_URL',	'http://www.address.com/');
	define ('MYSQL', '/path/to/mysql_connect.inc.php');
}

/* Najistotniejsze ustawienia:
 * Zmienna $debug jest używana podczas zarządzania reakcją na błędy.
 * Aby debugować określoną stronę, dopisz w odpowiednim skrypcie poniższy kod:
 *	$debug = TRUE;
 *	require_once('./includes/config.inc.php');
 * Aby debugować całą witrynę, dopisz:
 *  $debug = TRUE;
 * przed poniższym warunkiem.
 */
 
$debug = TRUE;
if (!isset($debug)) {
	$debug = FALSE;
}

// ************ USTAWIENIA ************ //
// ********************************** //


// ****************************************** //
// ************ OBSŁUGA BŁĘDÓW ************ //

// Utwórz funkcję obsługi błędów.
function my_error_handler ($e_number, $e_message, $e_file, $e_line, $e_vars) {

	global $debug, $contact_email;

	// Utwórz komunikat o błędzie.
	$message = "W skrypcie '$e_file' wystąpił błąd w wierszu $e_line: \n<br />$e_message\n<br />";
	
	// Dołącz dane i czas wystąpienia błędu.
	$message .= "data/czas: " . date('n-j-Y H:i:s') . "\n<br />";
	
	// Dołącz $e_vars do zmiennej $message.
	$message .= "<pre>" . print_r ($e_vars, 1) . "</pre>\n<br />";
	
	if ($debug) { // Nie wyświetlaj dokłądnej informacji o błędzie.
		echo '<div id="Error">' . $message . '</div><br />';
	} else { // Wytwarzanie (wyświetl błąd).
		error_log ($message, 1, $contact_email); // Wyślij e-mail.
		// Jeśli błąd nie jest powiadomieniem, wyświetl komunikat .
		if ($e_number != E_NOTICE) {
			echo '<div id="Error">Wystapił błąd. Przepraszamy za niedogodności.</div><br />';
		}
	}

} // Koniec funkcji my_error_handler().

// Ustaw funkcję obsługi błędów.
set_error_handler ('my_error_handler');

// ************ OBSŁUGA BŁĘDÓW ************ //
// ****************************************** //

?>
