<?php

// Skrypt umożliwia administratorowi dodawanie kaw.
// Skrypt jest tworzony w rozdziale 11.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na obsługę błędów.
require ('../includes/config.inc.php');

// Ustaw tytuł strony i dołącz plik nagłówka:
$page_title = 'Add Specific Coffees';
include ('./includes/header.html');
// W pliku nagłówka jest rozpoczynana sesja.

// Dołącz plik odpowiedzialny za połączenie z bazą danych:
require(MYSQL);

// Maksymalna liczba produktów, którą można dodać za jednym razem:
$count = 10;

// Sprawdź, czy formularz został przesłany:
if ($_SERVER['REQUEST_METHOD'] == 'POST') {	

	// Sprawdź kategorię:
	if (isset($_POST['category']) && filter_var($_POST['category'], FILTER_VALIDATE_INT, array('min_range' => 1))) {
		
		// Zdefiniuj kwerendę:
		$q = 'INSERT INTO specific_coffees (general_coffee_id, size_id, caf_decaf, ground_whole, price, stock) VALUES (?, ?, ?, ?, ?, ?)';

		// Przygotuj zapytanie:
		$stmt = mysqli_prepare($dbc, $q);
		
		// Powiąż zmienne:
		mysqli_stmt_bind_param($stmt, 'iissdi', $_POST['category'], $size, $caf_decaf, $ground_whole, $price, $stock);
		
		// Zmienna przechowująca liczbę zmodyfikowanych wierszy:
		$affected = 0;

		// Przejdź w pętil przez wszystkie zaktualizowane pozycje:
		for ($i = 1; $i <= $count; $i++) {
			
			// Sprawdź wymagane wartości:
			if (filter_var($_POST['stock'][$i], FILTER_VALIDATE_INT, array('min_range' => 1))
			&& filter_var($_POST['price'][$i], FILTER_VALIDATE_FLOAT) 
			&& ($_POST['price'][$i] > 0) ) {
				
				// Przypisz wartości do zmiennych:
				$size = $_POST['size'][$i];
				$caf_decaf = $_POST['caf_decaf'][$i];
				$ground_whole = $_POST['ground_whole'][$i];
				$price = $_POST['price'][$i];
				$stock = $_POST['stock'][$i];
				
				// Wykonaj kwerendę:
				mysqli_stmt_execute($stmt);
				
				// Dodaj liczbę zaktualizowanych wierszy:
				$affected += mysqli_stmt_affected_rows($stmt);
				
			} // Koniec instrukcji IF.

		} // Koniec pętli FOREACH.
		
		// Wyświetl liczbę zmodyfkowanych wierszy:
		echo "<h4>$affected produktów zostało dodanych!</h4>";

	} else {
		echo '<p class="error">Wybierz kategorię.</p>';
	}

} // Koniec instrukcji IF sprawdzającej przesłanie formularza.

?><h3>Dodaj kawy</h3>

<form action="add_specific_coffees.php" method="post" accept-charset="utf-8">

	<fieldset><legend>Wypełnij formularz, aby dodać określone kawy do katalogu sklepu.</legend>
		
		<div class="field"><label for="category"><strong>Ogólny typ kawy</strong></label><br />
		<select name="category"><option>Wybierz...</option>
		<?php // Retrieve all the categories and add to the pull-down menu:
		$q = 'SELECT id, category FROM general_coffees ORDER BY category ASC';		
		$r = mysqli_query ($dbc, $q);
			while ($row = mysqli_fetch_array ($r, MYSQLI_NUM)) {
				echo "<option value=\"$row[0]\">$row[1]</option>\n";
			}
		?>
		</select></div>
		
		<table border="0" width="100%" cellspacing="5" cellpadding="5">
			<thead>
				<tr>
			    <th align="right">Wielkość</th>
			    <th align="right">Mielona/ziarnista</th>
			    <th align="right">Kof./bezkof.</th>
			    <th align="center">Cena</th>
			    <th align="center">Stan magazynowy</th>
			  </tr>
			</thead>
			<tbody>
		<?php 
		
		// Pobierz dostępne wielkości opakowań:
		$q = 'SELECT id, size FROM sizes ORDER BY id ASC';		
		$r = mysqli_query ($dbc, $q);
		$sizes = '';
		while ($row = mysqli_fetch_array ($r, MYSQLI_NUM)) {
			$sizes .= "<option value=\"$row[0]\">$row[1]</option>\n";
		}
		
		// Ustal dostępne opcje rozdrobnienia:	
		$grinds = '<option value="ground">mielona</option><option value="whole">ziarnista</option>';
		
		// Need the caffeinated/decaffeinated options:
		$caf_decaf = '<option value="caf">kofeinowa</option><option value="decaf">bezkofeinowa</option>';
		
		// Utwórz zestaw pól dla $count produktów:
		for ($i = 1; $i <= $count; $i++) {
			echo '<tr>
			<td align="right"><select name="size[' . $i . ']">' . $sizes . '</select></td>
			<td align="right"><select name="ground_whole[' . $i . ']">' . $grinds . '</select></td>
			<td align="right"><select name="caf_decaf[' . $i . ']">' . $caf_decaf . '</select></td>
		    <td align="center"><input type="text" name="price[' . $i . ']" class="small" /></td>
		    <td align="center"><input type="text" name="stock[' . $i . ']" class="small" /></td>
			</tr>
		';
			
		} // Koniec pętli FOR.
		
		?></tbody>
		</table>

		<div class="field"><input type="submit" value="Dodaj produkty" class="button" /></div>
	
	</fieldset>

</form> 

<?php // Dołącz stopkę:
include ('./includes/footer.html');
?>
