<?php

// Skrypt odpowiada za rejestrację użytkowników w witrynie.
// Skrypt wyświetla i przetwarza formularz rejestracyjny.
// Skrypt jest tworzony od rozdziału 4.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na funkcję obsługi błędów:
require ('./includes/config.inc.php');
// W pliku jest również rozpoczynana sesja.

// Dołącz plik nagłówka:
$page_title = 'Rejestracja';
include ('./includes/header.html');

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require (MYSQL);

// Tablica błędów:
$reg_errors = array();

// Sprawdź, czy formularz został przesłany:
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

	// Sprawdź pole imienia:
	if (preg_match ('/^[A-ZąćęłńóśźżĄĆĘŁŃÓŚŹŻ \'.-]{2,20}$/i', $_POST['first_name'])) {
		$fn = mysqli_real_escape_string ($dbc, $_POST['first_name']);
	} else {
		$reg_errors['first_name'] = 'Wpisz swoje imię!';
	}
	
	// Sprawdź pole nazwiska:
	if (preg_match ('/^[A-ZąćęłńóśźżĄĆĘŁŃÓŚŹŻ \'.-]{2,40}$/i', $_POST['last_name'])) {
		$ln = mysqli_real_escape_string ($dbc, $_POST['last_name']);
	} else {
		$reg_errors['last_name'] = 'Wpisz swoje nazwisko!';
	}
	
	// Sprawdź pole nazwy użytkownika:
	if (preg_match ('/^[A-Z0-9]{2,30}$/i', $_POST['username'])) {
		$u = mysqli_real_escape_string ($dbc, $_POST['username']);
	} else {
		$reg_errors['username'] = 'Wpisz prawidłową nazwę użytkownika!';
	}
	
	// Sprawdź pole e-maila:
	if (filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
		$e = mysqli_real_escape_string ($dbc, $_POST['email']);
	} else {
		$reg_errors['email'] = 'Wpisz prawidłowy adres e-mail!';
	}

	// Sprawdź pole hasła i zweryfikuj poprawność z drugim polem hasła:
	if (preg_match ('/^(\w*(?=\w*\d)(?=\w*[a-z])(?=\w*[A-Z])\w*){6,20}$/', $_POST['pass1']) ) {
		if ($_POST['pass1'] == $_POST['pass2']) {
			$p = mysqli_real_escape_string ($dbc, $_POST['pass1']);
		} else {
			$reg_errors['pass2'] = 'Wprowadzone hasła nie są identyczne!';
		}
	} else {
		$reg_errors['pass1'] = 'Wpisz prawidłowe hasło!';
	}
	
	if (empty($reg_errors)) { // Jeśli wszystko jest w porządku...

		// Sprawdź, czy adres e-mail i nazwa użytkownika są dostępne:
		$q = "SELECT email, username FROM users WHERE email='$e' OR username='$u'";
		$r = mysqli_query ($dbc, $q);
		
		// Pobierz liczbę wierszy:
		$rows = mysqli_num_rows($r);
		
		if ($rows == 0) { // Wszystko w porządku!
			
			// Dodaj użytkownika do bazy danych...
			
			// Rozwiązanie tymczasowe: ustaw czas wygaśnięcia konta na miesiąc!
			// Zmień po dodaniu obsługi serwisu PayPal!
			//$q = "INSERT INTO users (username, email, pass, first_name, last_name, date_expires) VALUES ('$u', '$e', '"  .  get_password_hash($p) .  "', '$fn', '$ln', ADDDATE(NOW(), INTERVAL 1 MONTH) )";
			
			// Nowa kwerenda, zaktualizowana w rozdziale 6. podczas integrowania sklepu z serwisem PayPal:
			// Ustawia datę wygaśnięcia konta na wczoraj:
			$q = "INSERT INTO users (username, email, pass, first_name, last_name, date_expires) VALUES ('$u', '$e', '"  .  get_password_hash($p) .  "', '$fn', '$ln', SUBDATE(NOW(), INTERVAL 1 DAY) )";
			
			$r = mysqli_query ($dbc, $q);

			if (mysqli_affected_rows($dbc) == 1) { // Jeżeli OK.
							
				// Pobierz identyfikator użytkownika:
				// Zapisz nowy identyfikator w sesji:
				// Dodane w rozdziale 6.:
				$uid = mysqli_insert_id($dbc);
//				$_SESSION['reg_user_id']  = $uid;		
				
				// Wyświetl komunikat z podziękowaniem
				
				// Oryginalny komunikat z rodziału 4.:
				//echo '<h3>Dziękujemy!</h3><p>Możesz się teraz zalogować i korzystać z zasobów witryny.</p>';
				
				// Zmieniony komunikat z rozdziału 6.:
				echo "<h3>Dziękujemy za rejestrację!</h3><p>Aby zakończyć proces rejestracji, kliknij poniższy przycisk. Zostaniesz przekierowany do serwisu PayPal, gdzie możesz dokonać płatności. Opłata za dostęp do artykułów wynosi 50 zł rocznie. <strong>Uwaga: po dokonaniu płatności w systemie PayPal kliknij przycisk przekierowujący z powrotem na stronę Wiedza to potęga.</strong></p>";

				// Link do serwisu PayPal dodany w rozdziale 6.:
				echo '<form action="https://www.sandbox.paypal.com/cgi-bin/webscr" method="post">
				<input type="hidden" name="cmd" value="_s-xclick">
				<input type="hidden" name="custom" value="' . $uid . '">
				<input type="hidden" name="email" value="' . $e . '">
				<input type="hidden" name="hosted_button_id" value="3X3BXG58S5SXN">
				<input type="image" src="https://www.sandbox.paypal.com/pl_PL/PL/i/btn/btn_subscribeCC_LG.gif" border="0" name="submit" alt="PayPal - Proste i bezpieczne płatności internetowe!">
				<img alt="" border="0" src="https://www.sandbox.paypal.com/en_US/i/scr/pixel.gif" width="1" height="1">
				</form>
				';
						
				// Wysłąć osobny e-mail?
				$body = "Dziękujemy za zarejestrowanie się w naszej witrynie. Bla. Bla. Bla.\n\n";
				mail($_POST['email'], 'Potwierdzenie rejestracji', $body, 'From: admin@example.com');
				
				// Zakończ stronę:
				include ('./includes/footer.html'); // Dołącz stopkę.
				exit(); // Zatrzymaj wykonywanie kodu strony.
				
			} else { // Jeśli nie udało się poprawnie uruchomić kwerendy.
				trigger_error('Z powodu błędu systemu nie udało się dokonać rejestracji. Przepraszamy za kłopot.');
			}
			
		} else { // Niedostępny adres e-mail lub nazwa użytkownika.
			
			if ($rows == 2) { // Obie wartości są zajęte.
				
				$reg_errors['email'] = 'Podany adres e-mail został już zgłoszony. Jeżeli nie pamiętasz hasła, kliknij link znajdujący się obok, by hasło zostało wysłane na podany adres e-mail.';			
				$reg_errors['username'] = 'Podana nazwa użytkownika została już zgłoszona. Spróbuj wpisać inną.';			

			} else { // Jedna lub obie wartości są zajęte.

				// Pobierz wiersz:
				$row = mysqli_fetch_array($r, MYSQLI_NUM);
									
				if( ($row[0] == $_POST['email']) && ($row[1] == $_POST['username'])) { // Zajęte są obie wartości.
					$reg_errors['email'] = 'Podany adres e-mail został już zgłoszony. Jeżeli nie pamiętasz hasła, kliknij link znajdujący się obok, by hasło zostało wysłane na podany adres e-mail.';
					$reg_errors['username'] = 'Podana nazwa użytkownika została już zgłoszona. Jeżeli nie pamiętasz hasła, kliknij link znajdujący się obok, by hasło zostało wysłane na podany adres e-mail.';
				} elseif ($row[0] == $_POST['email']) { // Zajęty jest adres e-mail.
					$reg_errors['email'] = 'Podany adres e-mail został już zgłoszony. Jeżeli nie pamiętasz hasła, kliknij link znajdujący się obok, by hasło zostało wysłane na podany adres e-mail.';
				} elseif ($row[1] == $_POST['username']) { // Zajęta jest nazwa użytkownika.
					$reg_errors['username'] = 'Podana nazwa użytkownika została już zgłoszona. Spróbuj wpisać inną.';
				}
					
			} // Koniec ELSE $rows == 2.
			
		} // Koniec instrukcji IF $rows == 0.
		
	} // Koniec instrukcji IF empty($reg_errors).

} // Koniec głównego warunku przesyłania formularza.

// Wymagany jest skrypt zawierający funkcje definiujące create_form_input():
require ('./includes/form_functions.inc.php');
?><h3>Zarejestruj się</h3>
<p>Dostęp do zawartości strony mają tylko zarejestrowani użytkownicy. Koszt subskrypcji to 50 zł rocznie. Proces rejestracji rozpocznij od wypełnienia formularza. <strong>Uwaga: Wymagane jest wypełnienie wszystkich pól.</strong> Po zatwierdzeniu wprowadzonych danych będziesz mieć możliwość w pełni bezpiecznego opłacenia rocznej subskrypcji za pośrednictwem serwisu <a href="http://www.paypal.com">PayPal</a>.</p>
<form action="register.php" method="post" accept-charset="utf-8" style="padding-left:100px">

		<p><label for="first_name"><strong>Imię</strong></label><br /><?php create_form_input('first_name', 'text', $reg_errors); ?></p>
		
		<p><label for="last_name"><strong>Nazwisko</strong></label><br /><?php create_form_input('last_name', 'text', $reg_errors); ?></p>
		
		<p><label for="username"><strong>Nazwa użytkownika</strong></label><br /><?php create_form_input('username', 'text', $reg_errors); ?> <small>Możesz stosować tylko litery i cyfry.</small></p>
		
		<p><label for="email"><strong>Adres e-mail</strong></label><br /><?php create_form_input('email', 'text', $reg_errors); ?></p>
		
		<p><label for="pass1"><strong>Hasło</strong></label><br /><?php create_form_input('pass1', 'password', $reg_errors); ?> <small>Musi zawierać od 6 do 20 znaków, co najmniej jedną małą i dużą literę oraz cyfrę.</small></p>
		<p><label for="pass2"><strong>Powtórz hasło</strong></label><br /><?php create_form_input('pass2', 'password', $reg_errors); ?></p>

		<input type="submit" name="submit_button" value="Dalej &rarr;" id="submit_button" class="formbutton" />
	
</form>

<?php // Dołącz plik stopki:
include ('./includes/footer.html');
?>
