<?php

// W skrypcie są zdefiniowane funkcje wymagane przez formularze.
// Skrypt jest tworzony w rozdziale 4.

// Funkcja tworzy pole formularza typu INPUT lub TEXTAREA.
// Przyjmuje trzy argumenty:
// - Nazwę nadawaną polu tekstowemu.
// - Typ pola (text, password, textarea).
// - Tablicę błędów.
function create_form_input($name, $type, $errors) {
	
	// Załóż, że żadna wartość nie istnieje:
	$value = false;

	// Sprawdź wartość w tablicy POST:
	if (isset($_POST[$name])) $value = $_POST[$name];
	
	// Usuń ukośniki, jeśli mechanizm Magic Quotes jest włączony:
	if ($value && get_magic_quotes_gpc()) $value = stripslashes($value);

	// Zdecyduj o typie tworzonego pola:
	if ( ($type == 'text') || ($type == 'password') ) { // Utwórz pole typu text lub password.
		
		// Początek definicji pola:
		echo '<input type="' . $type . '" name="' . $name . '" id="' . $name . '"';
		
		// Do pola dodaj wartość:
		if ($value) echo ' value="' . htmlspecialchars($value) . '"';

		// Sprawdź, czy nie wystąpiły błędy:
		if (array_key_exists($name, $errors)) {
			echo 'class="error" /><span class="error">' . $errors[$name] . '</span>';
		} else {
			echo ' />';		
		}
		
	} elseif ($type == 'textarea') { // Utwórz pole typu TEXTAREA.
		
		// Najpierw wyświetl komunikat o błędzie: 
		if (array_key_exists($name, $errors)) echo ' <span class="error">' . $errors[$name] . '</span><br/>';

		// Początek definicji pola:
		echo '<textarea name="' . $name . '" id="' . $name . '" rows="5" cols="75"';
		
		// Jeśli trzeba, dodaj klasę błędu:
		if (array_key_exists($name, $errors)) {
			echo ' class="error">';
		} else {
			echo '>';		
		}
		
		// Dodaj wartość do pola textarea:
		if ($value) echo $value;

		// Zakończ kod pola textarea:
		echo '</textarea>';
		
	} // Koniec głównej instrukcji IF-ELSE.

} // koniec funkcji create_form_input().

// Pomiń zamykający znacznik PHP, by uniknąć błędów 'headers already sent'!
