<?php

// Skrypt wyświetla artykuły z danej kategorii.
// Skrypt jest tworzony w rozdziale 5.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na funkcję obsługi błędów:
require ('./includes/config.inc.php');
// W pliku jest również rozpoczynana sesja.

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require(MYSQL);

// Sprawdź poprawność identyfikatora kategorii:
if (filter_var($_GET['id'], FILTER_VALIDATE_INT, array('min_range' => 1))) {

	// Pobierz tytuł kategorii:
	$q = 'SELECT category FROM categories WHERE id=' . $_GET['id'];
	$r = mysqli_query($dbc, $q);
	if (mysqli_num_rows($r) != 1) { // Problem!
		$page_title = 'Błąd!';
		include ('./includes/header.html');
		echo '<p class="error">Podczas próby dostępu do tej strony pojawił się błąd.</p>';
		include ('./includes/footer.html');
		exit();
	}
	
	// Pobierz tytuł kategorii i użyj jej jako tytułu strony:
	list ($page_title) = mysqli_fetch_array($r, MYSQLI_NUM);
	include ('./includes/header.html');
	echo "<h3>$page_title</h3>";
	
	// Wyświetl komunikat jeśli użytkownik nie ma aktywnego konta:
	// Zmień komunikat w zależności od statusu:
	if (isset($_SESSION['user_id']) && !isset($_SESSION['user_not_expired'])) {
		echo '<p class="error">Dziękujemy za zainteresowanie artykułem. Niestety Twoje konto jest nieaktywne. <a href="renew.php">Odnów konto</a>, aby uzyskać dostęp do zasobów.</p>';
	} elseif (!isset($_SESSION['user_id'])) {
		echo '<p class="error">Dziękujemy za zainteresowanie artykułem, jednak aby uzyskać do niego dostęp, musisz się zalogować.</p>';
	}

	// Pobierz strony powiązane z kategorią:
	$q = 'SELECT id, title, description FROM pages WHERE category_id=' . $_GET['id'] . ' ORDER BY date_created DESC';
	$r = mysqli_query($dbc, $q);
	if (mysqli_num_rows($r) > 0) { // Pages available!
		
		// Pobierz wszystkie rekordy:
		while ($row = mysqli_fetch_array ($r, MYSQLI_ASSOC)) {

			// Wyświetl wszystkie rekordy:
			echo "<div><h4><a href=\"page.php?id={$row['id']}\">{$row['title']}</a></h4><p>{$row['description']}</p></div>\n";

		} // Koniec pętli WHILE.
		
	} else { // Brak dostępnych artykułów.
		echo '<p>Aktualnie w wybranej kategorii nie ma żadnych artykułów. Wróć za jakiś czas!</p>';
	}

} else { // Brak poprawnego identyfikatora.
	$page_title = 'Błąd!';
	include ('./includes/header.html');
	echo '<p class="error">Podczas próby dostępu do tej strony pojawił się błąd.</p>';
} // Koniec głównej instrukcji IF.

// Dołącz stopkę:
include ('./includes/footer.html');
?>
