<?php

// Skrypt dodaje stronę z zawartością do listy ulubionych pozycji użytkownika.
// To jest dodatkowy materiał, o którym jest mowa w rozdziale 5.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na funkcję obsługi błędów:
require ('./includes/config.inc.php');
// Plik konfiguracyjny rozpoczyna również sesję.

// Jeśli użytkownik nie jest aktywny, przekieruj go:
redirect_invalid_user('user_not_expired');

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require(MYSQL);

// Sprawdź identyfikator kategorii:
if (filter_var($_GET['id'], FILTER_VALIDATE_INT, array('min_range' => 1))) {

	// Pobierz informację o stronie:
	$q = 'SELECT title, description, content FROM pages WHERE id=' . $_GET['id'];
	$r = mysqli_query($dbc, $q);
	if (mysqli_num_rows($r) != 1) { // Problem!
		$page_title = 'Błąd!';
		include ('./includes/header.html');
		echo '<p class="error">Nie udało się wyświetlić strony.</p>';
		include ('./includes/footer.html');
		exit();
	}
	
	// Pobierz informacje o stronie:
	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);
	$page_title = $row['title'];
	include ('includes/header.html');
	echo "<h3>$page_title</h3>";
	
	// Dodaj pozycję do bazy danych:
	$q = 'REPLACE INTO favorite_pages (user_id, page_id) VALUES (' . $_SESSION['user_id'] . ', ' . $_GET['id'] . ')';
	$r = mysqli_query($dbc, $q);
	if (mysqli_affected_rows($dbc) == 1) {
			echo '<p><img src="/images/heart_48.png" border="0" width="48" height="48" align="middle" /> Strona została dodana do ulubionych! <a href="remove_from_favorites.php?id=' . $_GET['id'] . '"><img src="/images/cross_48.png" border="0" width="48" height="48" align="middle" /></a></p>';
	} else {
		trigger_error('Wystąpił błąd. Przepraszamy za niedogodności.');
	}

	// Wyświetl zawartość strony:
	echo "<div>{$row['content']}</div>";
		
} else { // Niepoprawny identyfikator.
	$page_title = 'Błąd!';
	include ('includes/header.html');
	echo '<p class="error">Nie udało się wyświetlić strony.</p>';
} // Konie cpodstawowej instrukcji IF.

// Dołącz plik HTML stopki:
include ('./includes/footer.html');
?>
