console.log(Number.isInteger(25));      // Wartość true.
console.log(Number.isInteger(25.0));    // Wartość true.
console.log(Number.isInteger(25.1));    // Wartość false.


--


console.log(Math.pow(2, 53));      // 9007199254740992.
console.log(Math.pow(2, 53) + 1);  // 9007199254740992.


--


var inside = Number.MAX_SAFE_INTEGER,
    outside = inside + 1;
console.log(Number.isInteger(inside));          // Wartość true.
console.log(Number.isSafeInteger(inside));      // Wartość true.

console.log(Number.isInteger(outside));         // Wartość true.
console.log(Number.isSafeInteger(outside));     // Wartość false.


--


// Dozwolone w ECMAScript 5 i 6.
var \u0061 = "abc";

console.log(\u0061);     // "abc"

// Powyższe polecenie jest odpowiednikiem poniższego.
console.log(a);          // "abc"


--


// Dozwolone w ECMAScript 5 i 6.
var \u{61} = "abc";

console.log(\u{61});     // "abc"

// Powyższe polecenie jest odpowiednikiem poniższego.
console.log(a);          // "abc"


--


let person = {
    getGreeting() {
        return "Cześć";
    }
};

let dog = {
    getGreeting() {
        return "Hau";
    }
};

// Prototyp to person.
let friend = {
    __proto__: person
};
console.log(friend.getGreeting());                      // "Cześć".
console.log(Object.getPrototypeOf(friend) === person);  // Wartość true.
console.log(friend.__proto__ === person);               // Wartość true.

// Zdefiniowanie dog jako prototypu.
friend.__proto__ = dog;
console.log(friend.getGreeting());                      // "Hau".
console.log(friend.__proto__ === dog);                  // Wartość true.
console.log(Object.getPrototypeOf(friend) === dog);     // Wartość true.
