var colors = ["czerwony", "zielony", "niebieski"];

for (var i = 0, len = colors.length; i < len; i++) {
    console.log(colors[i]);
}


--


function createIterator(items) {

    var i = 0;

    return {
        next: function() {

            var done = (i >= items.length);
            var value = !done ? items[i++] : undefined;
            return {
                done: done,
                value: value
            };

        }

    };

}

var iterator = createIterator([1, 2, 3]);

console.log(iterator.next());           // "{ value: 1, done: false }".
console.log(iterator.next());           // "{ value: 2, done: false }".
console.log(iterator.next());           // "{ value: 3, done: false }".
console.log(iterator.next());           // "{ value: undefined, done: true }".

// W przypadku wszystkich kolejnych wywołań.
console.log(iterator.next());           // "{ value: undefined, done: true }".


--


// Generator.
function *createIterator() {
    yield 1;
    yield 2;
    yield 3;
}

// Generator jest wywoływany dokładnie tak samo jak zwykła funkcja, ale zwraca iterator.
let iterator = createIterator();

console.log(iterator.next().value);     // 1.
console.log(iterator.next().value);     // 2.
console.log(iterator.next().value);     // 3.


--


function *createIterator(items) {
    for (let i = 0; i < items.length; i++) {
        yield items[i];
    }
}

let iterator = createIterator([1, 2, 3]);

console.log(iterator.next());           // "{ value: 1, done: false }".
console.log(iterator.next());           // "{ value: 2, done: false }".
console.log(iterator.next());           // "{ value: 3, done: false }".
console.log(iterator.next());           // "{ value: undefined, done: true }".

// Dla wszystkich kolejnych wywołań.
console.log(iterator.next());           // "{ value: undefined, done: true }".


--


function *createIterator(items) {

    items.forEach(function(item) {

        // Błąd składni.
        yield item + 1;
    });
}


--


let createIterator = function *(items) {
    for (let i = 0; i < items.length; i++) {
        yield items[i];
    }
};

let iterator = createIterator([1, 2, 3]);

console.log(iterator.next());           // "{ value: 1, done: false }".
console.log(iterator.next());           // "{ value: 2, done: false }".
console.log(iterator.next());           // "{ value: 3, done: false }".
console.log(iterator.next());           // "{ value: undefined, done: true }".

// Dla wszystkich kolejnych wywołań.
console.log(iterator.next());           // "{ value: undefined, done: true }".


--


let o = {

    createIterator: function *(items) {
        for (let i = 0; i < items.length; i++) {
            yield items[i];
        }
    }
};

let iterator = o.createIterator([1, 2, 3]);


--


let o = {

    *createIterator(items) {
        for (let i = 0; i < items.length; i++) {
            yield items[i];
        }
    }
};

let iterator = o.createIterator([1, 2, 3]);


--


let values = [1, 2, 3];

for (let num of values) {
    console.log(num);
}


--


let values = [1, 2, 3];
let iterator = values[Symbol.iterator]();

console.log(iterator.next());           // "{ value: 1, done: false }".
console.log(iterator.next());           // "{ value: 2, done: false }".
console.log(iterator.next());           // "{ value: 3, done: false }".
console.log(iterator.next());           // "{ value: undefined, done: true }".


--


function isIterable(object) {
    return typeof object[Symbol.iterator] === "function";
}

console.log(isIterable([1, 2, 3]));          // Wartość true.
console.log(isIterable("Hello"));            // Wartość true.
console.log(isIterable(new Map()));          // Wartość true.
console.log(isIterable(new Set()));          // Wartość true.
console.log(isIterable(new WeakMap()));      // Wartość false.
console.log(isIterable(new WeakSet()));      // Wartość false.


--


let collection = {
    items: [],
    *[Symbol.iterator]() {
        for (let item of this.items) {
            yield item;
        }
    }

};

collection.items.push(1);
collection.items.push(2);
collection.items.push(3);

for (let x of collection) {
    console.log(x);
}


--


let colors = [ "czerwony", "zielony", "niebieski" ];
let tracking = new Set([1234, 5678, 9012]);
let data = new Map();

data.set("title", "Poznajemy ECMAScript 6");
data.set("format", "ebook");

for (let entry of colors.entries()) {
    console.log(entry);
}

for (let entry of tracking.entries()) {
    console.log(entry);
}

for (let entry of data.entries()) {
    console.log(entry);
}


--


let colors = [ "czerwony", "zielony", "niebieski" ];
let tracking = new Set([1234, 5678, 9012]);
let data = new Map();

data.set("title", "Poznajemy ECMAScript 6");
data.set("format", "ebook");

for (let value of colors.values()) {
    console.log(value);
}

for (let value of tracking.values()) {
    console.log(value);
}

for (let value of data.values()) {
    console.log(value);
}


--


let colors = [ "czerwony", "zielony", "niebieski" ];
let tracking = new Set([1234, 5678, 9012]);
let data = new Map();

data.set("title", "Poznajemy ECMAScript 6");
data.set("format", "ebook");

for (let key of colors.keys()) {
    console.log(key);
}

for (let key of tracking.keys()) {
    console.log(key);
}

for (let key of data.keys()) {
    console.log(key);
}


--


let colors = [ "czerwony", "zielony", "niebieski" ];
let tracking = new Set([1234, 5678, 9012]);
let data = new Map();

data.set("title", "Poznajemy ECMAScript 6");
data.set("format", "print");

// Taki sam efekt jak w przypadku użycia colors.values().
for (let value of colors) {
    console.log(value);
}

// Taki sam efekt jak w przypadku użycia tracking.values().
for (let num of tracking) {
    console.log(num);
}

// Taki sam efekt jak w przypadku użycia data.entries().
for (let entry of data) {
    console.log(entry);
}


--


let data = new Map();

data.set("title", "Poznajemy ECMAScript 6");
data.set("format", "ebook");

// Taki sam efekt jak w przypadku użycia data.entries().
for (let [key, value] of data) {
    console.log(key + "=" + value);
}


--


var message = "A 𠮷 B";

for (let i=0; i < message.length; i++) {
    console.log(message[i]);
}


--


var message = "A 𠮷 B";

for (let c of message) {
    console.log(c);
}


--


var divs = document.getElementsByTagName("div");

for (let div of divs) {
    console.log(div.id);
}


--


let set = new Set([1, 2, 3, 3, 3, 4, 5]),
    array = [...set];

console.log(array);             // [1,2,3,4,5].


--


let map = new Map([["name", "Nicholas"], ["age", 25]]),
    array = [...map];

console.log(array);             // [["name", "Nicholas"], ["age", 25]].


--


let smallNumbers = [1, 2, 3],
    bigNumbers = [100, 101, 102],
    allNumbers = [0, ...smallNumbers, ...bigNumbers];

console.log(allNumbers.length);     // 7.
console.log(allNumbers);            // [0, 1, 2, 3, 100, 101, 102].


--


function *createIterator() {
    let first = yield 1;
    let second = yield first + 2;       // 4 + 2.
    yield second + 3;                   // 5 + 3.
}

let iterator = createIterator();

console.log(iterator.next());           // "{ value: 1, done: false }".
console.log(iterator.next(4));          // "{ value: 6, done: false }".
console.log(iterator.next(5));          // "{ value: 8, done: false }".
console.log(iterator.next());           // "{ value: undefined, done: true }".


--


function *createIterator() {
    let first = yield 1;
    let second = yield first + 2;       // Wykonanie polecenia yield 4 + 2, a następnie throw().
    yield second + 3;                   // To polecenie nigdy nie zostanie wykonane.
}

let iterator = createIterator();

console.log(iterator.next());                   // "{ value: 1, done: false }".
console.log(iterator.next(4));                  // "{ value: 6, done: false }".
console.log(iterator.throw(new Error("Bum")));  // Zgłoszenie błędu przez generatora.


--


function *createIterator() {
    let first = yield 1;
    let second;

    try {
        second = yield first + 2;       // Wykonanie polecenia yield 4 + 2, a następnie throw().
    } catch (ex) {
        second = 6;                     // W przypadku zgłoszenia błędu należy przypisać inną wartość.
    }
    yield second + 3;
}

let iterator = createIterator();

console.log(iterator.next());                   // "{ value: 1, done: false }".
console.log(iterator.next(4));                  // "{ value: 6, done: false }".
console.log(iterator.throw(new Error("Bum")));  // "{ value: 9, done: false }".
console.log(iterator.next());                   // "{ value: undefined, done: true }".


--


function *createIterator() {
    yield 1;
    return;
    yield 2;
    yield 3;
}

let iterator = createIterator();

console.log(iterator.next());           // "{ value: 1, done: false }".
console.log(iterator.next());           // "{ value: undefined, done: true }".


--


function *createIterator() {
    yield 1;
    return 42;
}

let iterator = createIterator();

console.log(iterator.next());           // "{ value: 1, done: false }".
console.log(iterator.next());           // "{ value: 42, done: true }".
console.log(iterator.next());           // "{ value: undefined, done: true }".


--


function *createNumberIterator() {
    yield 1;
    yield 2;
}

function *createColorIterator() {
    yield "czerwony";
    yield "zielony";
}

function *createCombinedIterator() {
    yield *createNumberIterator();
    yield *createColorIterator();
    yield true;
}

var iterator = createCombinedIterator();

console.log(iterator.next());           // "{ value: 1, done: false }".
console.log(iterator.next());           // "{ value: 2, done: false }".
console.log(iterator.next());           // "{ value: "czerwony", done: false }".
console.log(iterator.next());           // "{ value: "zielony", done: false }".
console.log(iterator.next());           // "{ value: true, done: false }".
console.log(iterator.next());           // "{ value: undefined, done: true }".


--


function *createNumberIterator() {
    yield 1;
    yield 2;
    return 3;
}

function *createRepeatingIterator(count) {
    for (let i=0; i < count; i++) {
        yield "powtórzenie";
    }
}
function *createCombinedIterator() {
    let result = yield *createNumberIterator();
    yield *createRepeatingIterator(result);
}

var iterator = createCombinedIterator();

console.log(iterator.next());           // "{ value: 1, done: false }".
console.log(iterator.next());           // "{ value: 2, done: false }".
console.log(iterator.next());           // "{ value: "powtórzenie", done: false }".
console.log(iterator.next());           // "{ value: "powtórzenie", done: false }".
console.log(iterator.next());           // "{ value: "powtórzenie", done: false }".
console.log(iterator.next());           // "{ value: undefined, done: true }".


--


function *createNumberIterator() {
    yield 1;
    yield 2;
    return 3;
}

function *createRepeatingIterator(count) {
    for (let i=0; i < count; i++) {
        yield "powtórzenie";
    }

}

function *createCombinedIterator() {
    let result = yield *createNumberIterator();
    yield result;
    yield *createRepeatingIterator(result);
}

var iterator = createCombinedIterator();

console.log(iterator.next());           // "{ value: 1, done: false }".
console.log(iterator.next());           // "{ value: 2, done: false }".
console.log(iterator.next());           // "{ value: 3, done: false }".
console.log(iterator.next());           // "{ value: "powtórzenie", done: false }".
console.log(iterator.next());           // "{ value: "powtórzenie", done: false }".
console.log(iterator.next());           // "{ value: "powtórzenie", done: false }".
console.log(iterator.next());           // "{ value: undefined, done: true }".


--


let fs = require("fs");

fs.readFile("config.json", function(err, contents) {
    if (err) {
        throw err;
    }

    doSomethingWith(contents);
    console.log("Gotowe!");
});


--


function run(taskDef) {

    // Utworzenie iteratora i udostępnienie go w kodzie.
    let task = taskDef();

    // Uruchomienie zadania.
    let result = task.next();

    // Funkcja rekurencyjna nieustannie wywołująca metodę next().
    function step() {

        // Jeżeli zostało cokolwiek do zrobienia.
        if (!result.done) {
            result = task.next();
            step();
        }

    }

    // Uruchomienie procesu.
    step();

}


--


run(function*() {
    console.log(1);
    yield;
    console.log(2);
    yield;
    console.log(3);
});


--


function run(taskDef) {

    // Utworzenie iteratora i udostępnienie go w kodzie.
    let task = taskDef();

    // Uruchomienie zadania.
    let result = task.next();

    // Funkcja rekurencyjna nieustannie wywołująca metodę next().
    function step() {

        // Jeżeli zostało cokolwiek do zrobienia.
        if (!result.done) {
            result = task.next(result.value);
            step();
        }

    }

    // Uruchomienie procesu.
    step();

}


--


run(function*() {
    let value = yield 1;
    console.log(value);         // 1.
    value = yield value + 3;
    console.log(value);         // 4.
});


--


function fetchData() {
    return function(callback) {
        callback(null, "Cześć!");
    };
}


--


function fetchData() {
    return function(callback) {
        setTimeout(function() {
            callback(null, "Cześć!");
        }, 50);
    };
}


--


function run(taskDef) {

    // Utworzenie iteratora i udostępnienie go w kodzie.
    let task = taskDef();

    // Uruchomienie zadania.
    let result = task.next();

    // Funkcja rekurencyjna nieustannie wywołująca metodę next().
    function step() {

        // Jeżeli zostało cokolwiek do zrobienia.
        if (!result.done) {
            if (typeof result.value === "function") {
                result.value(function(err, data) {
                    if (err) {
                        result = task.throw(err);
                        return;
                    }

                    result = task.next(data);
                    step();
                });
            } else {
                result = task.next(result.value);
                step();
            }
        }
    }

    // Uruchomienie procesu.
    step();

}


--


let fs = require("fs");

function readFile(filename) {
    return function(callback) {
        fs.readFile(filename, callback);
    };
}


--


run(function*() {
    let contents = yield readFile("config.json");
    doSomethingWith(contents);
    console.log("Gotowe!");
});
