package com.packtpub.e4.application.parts;

import javax.annotation.PostConstruct;
import javax.inject.Inject;

import org.eclipse.e4.ui.services.internal.events.EventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import com.packtpub.e4.application.IStringService;
import com.packtpub.e4.application.StringService;

public class Rainbow {
	private static final Object[] rainbow = { "Czerwony", "Pomaraczowy",
			"ty", "Zielony", "Niebieski", "Indygo", "Filetowy" };
	@Inject
	private ESelectionService selectionService;
	@Inject
	EventBroker broker;
	@Inject
	private IStringService stringService;

	@PostConstruct
	public void create(Composite parent) {
		ListViewer lv = new ListViewer(parent, SWT.NONE);
		lv.setContentProvider(new ArrayContentProvider());
		lv.setInput(rainbow);
		lv.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection sel = (IStructuredSelection) event
						.getSelection();
				Object colour = sel.getFirstElement();
				broker.post("rainbow/colour",
						stringService.process(colour.toString()));
			}

		});

	}
}
