Attribute VB_Name = "MFormStyles"
'
' Opis:         Modul do modyfikacji stylow okna formularza
'
' Autor:        Stephen Bullen, www.oaltd.co.uk
'

Option Explicit

''''''''''''''''''''''''''''''''''''''''''''''''''
' Deklaracje i stale Windows API
''''''''''''''''''''''''''''''''''''''''''''''''''

'Wywolania Windows API do wykonywania calej brudnej roboty
Private Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long) As Long
Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function GetSystemMenu Lib "user32" (ByVal hwnd As Long, ByVal bRevert As Long) As Long
Private Declare Function DeleteMenu Lib "user32" (ByVal hMenu As Long, ByVal nPosition As Long, ByVal wFlags As Long) As Long
Private Declare Function DrawMenuBar Lib "user32" (ByVal hwnd As Long) As Long

'Stale Window API
Private Const GWL_STYLE As Long = (-16)           'Ofset stylu okna
Private Const GWL_EXSTYLE As Long = (-20)         'Ofset rozszerzonego stylu okna
Private Const WS_CAPTION As Long = &HC00000       'Styl do dodania paska tytulu
Private Const WS_SYSMENU As Long = &H80000        'Styl do dodania menu systemowego
Private Const WS_DLGFRAME = &H400000
Private Const WS_THICKFRAME As Long = &H40000     'Styl do dodania ramki o zmiennych rozmiarach
Private Const WS_MINIMIZEBOX As Long = &H20000    'Styl do dodania pola minimalizuj do paska tytulowego
Private Const WS_MAXIMIZEBOX As Long = &H10000    'Styl do dodania pola maksymalizuje do paska tytulowego
Private Const WS_EX_DLGMODALFRAME As Long = &H1   'Kontroluje czy okno ma ikone
Private Const WS_EX_TOOLWINDOW As Long = &H80     'Okno narzedziowe: maly pasek tytulowy
Private Const SC_CLOSE As Long = &HF060           'Element menu zamknij


''''''''''''''''''''''''''''''''''''''''''''''''''
' Typy wyliczeniowe modulu
''''''''''''''''''''''''''''''''''''''''''''''''''

'Publiczne wyliczenie styli formularza
Public Enum UserformWindowStyles
    uwsNoTitleBar = 0
    uwsHasTitleBar = 1
    uwsHasSmallTitleBar = 2
    uwsHasMaxButton = 4
    uwsHasMinButton = 8
    uwsHasCloseButton = 16
    uwsHasIcon = 32
    uwsCanResize = 64
    uwsDefault = uwsHasTitleBar Or uwsHasCloseButton
End Enum


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komentarze: Metoda do okreslenie stylu okna formularza, wywolywana
'             ze zdarzenia Userform_Initialize
'
' Argumenty:    frmHwnd     Uchwyt okna formularza
'               lStyles     Wartosc wyliczeniowa dla stylu(ow) do ustawienia.
'                           Wartosci wyliczeniowe moga byc dodawane, aby
'                           okreslic wiele stylow w jednym wywolaniu.
'               sIconPath   Jesli styl uwsHasIcon jest podany, jest to sciezka
'                           do pliku ikony uzytej dla formularza
'
' Data          Deweloper       Dzialanie
' --------------------------------------------------------------
' 05 Cze 04     Stephen Bullen  Utworzyl
'
Sub SetUserformAppearance(ByVal frmHwnd As Long, ByVal lStyles As UserformWindowStyles)

    Dim lStyle As Long
    Dim hMenu As Long

    'Jesli chcemy miec maly pasek tylulowy, nie mozemy miec ikony oraz przyciskow max i min
    If lStyles And uwsHasSmallTitleBar Then
        lStyles = lStyles And Not (uwsHasMaxButton Or uwsHasMinButton Or uwsHasIcon)
    End If

    'Pobranie bitow styli normalnego okna
    lStyle = GetWindowLong(frmHwnd, GWL_STYLE)

    'Uaktualnienie bitow normalnego stylu odpowiednio

    'Jesli chcemy ikone lub przuciski Max, Min lub Zamnknij, musimy miec menu systemowe
    ModifyStyles lStyle, lStyles, uwsHasIcon Or uwsHasMaxButton Or uwsHasMinButton Or uwsHasCloseButton, WS_SYSMENU

    'Wiekszosc rzeczy wymaga paska tytulu!
    ModifyStyles lStyle, lStyles, uwsHasIcon Or uwsHasMaxButton Or uwsHasMinButton Or uwsHasCloseButton Or uwsHasTitleBar Or uwsHasSmallTitleBar, WS_CAPTION

    ModifyStyles lStyle, lStyles, uwsHasMaxButton, WS_MAXIMIZEBOX
    ModifyStyles lStyle, lStyles, uwsHasMinButton, WS_MINIMIZEBOX
    ModifyStyles lStyle, lStyles, uwsCanResize, WS_THICKFRAME

    lStyle = lStyle And Not WS_DLGFRAME

    'Uaktualnienie okna z normalnymi bitami stylu
    SetWindowLong frmHwnd, GWL_STYLE, lStyle

    'Pobranie bitow rozszerzonego stylu
    lStyle = GetWindowLong(frmHwnd, GWL_EXSTYLE)

    'Odpowiednia ich modyfikacja
    ModifyStyles lStyle, lStyles, uwsHasSmallTitleBar, WS_EX_TOOLWINDOW

    'Ikona jest inna od wszystkich - okreslamy bit, aby ja wylaczyc, nie wlaczyc!
    lStyle = lStyle And Not WS_EX_DLGMODALFRAME
    lStyle = lStyle And Not &H100

    'Uaktualniamy okno bitami rozszerzonego stylu
    SetWindowLong frmHwnd, GWL_EXSTYLE, lStyle

    'Przycisk Close jest obslugiwany przez usuniecie go z menu systemowego, nie przez bit stylu okna
    If lStyles And uwsHasCloseButton Then
        'chcemy, wiec resetujemy menu systemowego
        hMenu = GetSystemMenu(frmHwnd, 1)
    Else
        'Nie chcemy, wiec usuwamy z menu systemowego
        hMenu = GetSystemMenu(frmHwnd, 0)
        DeleteMenu hMenu, SC_CLOSE, 0&
    End If

    'Odswiezenie okna ze zmianami
    DrawMenuBar frmHwnd

End Sub


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komentarze: Metoda pomocnicza do sprawdzanie czy jeden z naszych bitow stylu jest okreslony
'           i ustawianie/czyszczenie odpowiedniegio buty stylu Windows
'
' Data          Deweloper       Dzialanie
' --------------------------------------------------------------
' 05 Cze 04     Stephen Bullen  Utworzyl
'
Private Sub ModifyStyles(ByRef lFormStyle As Long, ByVal lStyleSet As Long, ByVal lChoice As UserformWindowStyles, ByVal lWS_Style As Long)

    If lStyleSet And lChoice Then
        lFormStyle = lFormStyle Or lWS_Style
    Else
        lFormStyle = lFormStyle And Not lWS_Style
    End If

End Sub

