VERSION 5.00
Begin VB.UserControl OACTPHostControl 
   AutoRedraw      =   -1  'True
   BackColor       =   &H80000005&
   ClientHeight    =   3600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   ClipControls    =   0   'False
   ScaleHeight     =   3600
   ScaleWidth      =   4800
End
Attribute VB_Name = "OACTPHostControl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komentarze: Formant ActiveX do obslugi formularza VBA. Istnieje
'           pare spraw, ktore musza byc wykonane:
'           - Pobranei uchwytu okna formularza
'           - Okreslenie formularza jako dziecka formantu ActiveX
'           - Usuniecie paska tytulowego formularza i ramki
'           - Pokazanie formularza niemodalnie
'           - Zmiana rozmiarow okna formularza, gdy formant zmienia rozmiary
'           - (OOpcjonalnie) zmienia rozmiary formantow przy zmianie swoich rozmiarow
'
' Autor:    Stephen Bullen
' Data:     20 Paz 2005
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Option Explicit

Dim mhWndForm As Long                                                'Uchwyt okna formularza
Dim mbResizing As Boolean                                            'Czy powinnismy zmieniac rozmiery formantow formularza
Dim moResizer As CFormResizer                                        'Instancja klasy do zmiany rozmiarow formularza
Dim mfrm As Object

'Wywolanie API uzywane do znalezienie, modyfikacji i przesuwania okna formularza
Private Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long
Private Declare Function SetParent Lib "user32" (ByVal hWndChild As Long, ByVal hWndNewParent As Long) As Long
Private Declare Function MoveWindow Lib "user32" (ByVal hwnd As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bRepaint As Long) As Long


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komentarze: Wywolywane przez klase CTPUserformHost, aby powiedziec
'           formantowi, ktory formularz obsluzyc.
'
' Arguments:    oFrm    Formularz VBA do obslugi
'
' Data          Deweloper           Dzialanie
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' 20 Paz 2005   Stephen Bullen      Utworzyl
'
Public Sub HostForm(ByRef oFrm As Object)

    Dim sOldCaption As String
    Dim sTempCaption As String

    On Error Resume Next
Set mfrm = oFrm

    'Znajdowanie uchwytu okna formularza, nadajac mu unikalny tytul i szukajac go
    sOldCaption = oFrm.Caption
    sTempCaption = "CTPForm" & Rnd()
    oFrm.Caption = sTempCaption
    mhWndForm = FindWindow(vbNullString, sTempCaption)
    oFrm.Caption = sOldCaption

    'Czy znalezlismy?
    If mhWndForm <> 0 Then

        'Tworzenie nowej instancji klasy, ktora obsluzy
        'zmiany rozmiarow formularza i podanie jej formularza do obslugi
        Set moResizer = New CFormResizer
        Set moResizer.Form = oFrm

        'Nadanie koloru tla formantu ActiveX, aby pasowal do formularza
        'aby zredukowac migotanie podczas zmiany rozmiarow panelu zadan
        UserControl.BackColor = oFrm.BackColor

        'Uczynienie formularza dzieckiem formantu ActiveX
        SetParent mhWndForm, UserControl.hwnd

        'Modyfikacja formularza, aby usunac pasek tytulowy i ramke
        SetUserformAppearance mhWndForm, uwsNoTitleBar

        'Pokazanie formularza niemodalnie
        oFrm.Show vbModeless

        'Okreslenie poczatkowego rozmiaru i dopasowanie do panelu zadan
        UserControl_Resize
    End If

End Sub


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komantarze: Wlasciwosci przekazywane dla klasy CTPUserformHost,
'           informuja czy obslugiwac zmiany rozmiarow formantow formularza
'
' Data          Deweloper           Dzialanie
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' 20 Oct 2005   Stephen Bullen      Utworzyl
'
Public Property Let HandleResizing(bNew As Boolean)
    mbResizing = bNew
End Property

Public Property Get HandleResizing() As Boolean
    HandleResizing = mbResizing
End Property

'Aby obejsc Beta 1 bug, wymiszamy zmiany rozmiarow przy usuwaniu zadokowania
Public Sub DockPositionStateChange(ByVal NewPosition As MsoCTPDockPosition, ByVal dHeight As Double, ByVal dWidth As Double)
    'UserControl.Height = dHeight
    'UserControl.Width = dWidth
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komentarze: Wywolywane, gdy formant ActiveX ma zmieniane rozmiary przez
'           panel zadan. Opcjonalne informujamu klase Resizer,
'           aby zmieni rozmiar/polozenie formantow, nastepnei uzywamy
'           MoveWindow, aby zmienic rozmier okna formularza.
'           Powoduje to takze wywolanie zdarzenia VBA Userform_Resize.
'
' Data          Deweloper           Dzialanie
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' 20 Paz 2005   Stephen Bullen      Utworzyl
'
Private Sub UserControl_Resize()
    On Error Resume Next

    'Czy mamy formularz?
    If mhWndForm <> 0 Then

        With UserControl

            mfrm.Controls("lblResizeStop").Caption = "Resizing" & vbLf & Format(Now(), "hh:mm:ss") & vbLf & .ScaleWidth & vbLf & .ScaleHeight

            'Jesli powinnismy obslurzyc zmiany rozmierow, nakazujemy to klasie
            If mbResizing Then
                moResizer.FormResize .ScaleX(.ScaleWidth, .ScaleMode, vbPoints), _
                                     .ScaleY(.ScaleHeight, .ScaleMode, vbPoints)
            End If

            'Nadanie rozmiaru okna formularza, aby odpowiadal panelowi zadan
            MoveWindow mhWndForm, 0, 0, .ScaleX(.ScaleWidth, .ScaleMode, vbPixels), _
                       .ScaleY(.ScaleHeight, .ScaleMode, vbPixels), 1
        End With
    End If

End Sub

