VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CTPUserformHost"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komentarze: Klasa do opakowanie Office 12 Custom Task Pane, dodajac
'           zdolnosc obslugi VBA Userform.
'
'           Wykonujemy to tworzac  Custom Task Pane z naszym
'           formantem ActiveX, a nastepnie nakazujac formantowi
'           obsluge (host) formularza.
'
'           Klasa eksponuje wszystkie wlasciwosci i zdarzenia obiektu
'           Office 12 CustomTaskPane, plus pare dodatkow!
'
' Autor :   Stephen Bullen
' Date:     20 Paz 2005
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Option Explicit

'Obiekt Office 12 CustomTaskPane, ktory rozszerzamy
Dim WithEvents moCTP As CustomTaskPane
Attribute moCTP.VB_VarHelpID = -1

'Zdarzenia, ktore odpowiadaja zdarzeniom CTP - chociaz przekazujemy takze nowe stany (nie Office 12 CTP)
Public Event VisibleStateChange(ByVal Visible As Boolean)
Attribute VisibleStateChange.VB_MemberFlags = "200"
Public Event DockPositionStateChange(ByVal NewPosition As MsoCTPDockPosition)


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komentarze: Wywolywane przez klase Connect do utworzenia panelu zadan.
'           Tworzymu wlasny panel zadan zawierajacy nasz formant ActiveX,
'           a nastepnei nakazujemy formantowi obsluge formularza.
'
' Argumenty:    oFactory    Obiekt Office 12 CustomTaskPaneFactory
'               oForm       VBA Userform do obslugi
'               sCaption    Etykieta nowego panelu zadan
'
' Data          Deweloper           Dzialanie
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' 20 Paz 2005   Stephen Bullen      Utworzyl
'
Friend Sub CreateTaskPane(ByRef oFactory As ICTPFactory, ByRef oForm As Object, ByVal sCaption As String, ByRef Window As Object)

    On Error GoTo Err_Exit
    
    'Tworzenie wlasnego panelui zadan z naszym formantem ActiveX
    Set moCTP = oFactory.CreateCTP("OACTPUserformHost.OACTPHostControl", sCaption, Window)
    
    'Nakazanie formantowi obsluge formularza
    moCTP.ContentControl.HostForm oForm

Err_Exit:

End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'   Wlasciwosci do eksponowanie standardowych wlasciwosci CustomTaskPane
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Public Property Get Title() As String
Attribute Title.VB_MemberFlags = "200"
    On Error Resume Next
    If Not moCTP Is Nothing Then Title = moCTP.Title
End Property


Public Property Get DockPosition() As MsoCTPDockPosition
    On Error Resume Next
    If Not moCTP Is Nothing Then DockPosition = moCTP.DockPosition
End Property

Public Property Let DockPosition(lNew As MsoCTPDockPosition)
    On Error Resume Next
    If Not moCTP Is Nothing Then moCTP.DockPosition = lNew
End Property


Public Property Get DockPositionRestrict() As MsoCTPDockPositionRestrict
    On Error Resume Next
    If Not moCTP Is Nothing Then DockPositionRestrict = moCTP.DockPositionRestrict
End Property

Public Property Let DockPositionRestrict(lNew As MsoCTPDockPositionRestrict)
    On Error Resume Next
    If Not moCTP Is Nothing Then moCTP.DockPositionRestrict = lNew
End Property


Public Property Get Visible() As Boolean
    On Error Resume Next
    If Not moCTP Is Nothing Then Visible = moCTP.Visible
End Property

Public Property Let Visible(bNew As Boolean)
    On Error Resume Next
    If Not moCTP Is Nothing Then moCTP.Visible = bNew
End Property


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'   Procedury do eksponowanie standardowych metos CustomTaskPane
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Public Sub Delete()
    On Error Resume Next
    If Not moCTP Is Nothing Then
        moCTP.Delete
    End If
End Sub


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'   Procedury zdarzen do eksponowanie standardowych zdarzen CustomTaskPane
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub moCTP_DockPositionStateChange(ByVal CustomTaskPaneInst As Office.CustomTaskPane)
    On Error Resume Next
    moCTP.ContentControl.DockPositionStateChange moCTP.DockPosition, CustomTaskPaneInst.Height, CustomTaskPaneInst.Width
    RaiseEvent DockPositionStateChange(moCTP.DockPosition)
End Sub


Private Sub moCTP_VisibleStateChange(ByVal CustomTaskPaneInst As Office.CustomTaskPane)
    On Error Resume Next
    RaiseEvent VisibleStateChange(moCTP.Visible)
End Sub


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komentarze: Dodatkowa wlasciwosc, ktora okresla czy nasz
'           formant ActiveX powinien automatycznie obsluzyc
'           zmiany rozmiarow i pozycji formantow formularza.
'           Jesli ma wartosc True, formanty beda mialy zmieniony
'           rozmiar i pozycje zgodnie z ich wlasciwoscia Tag.
'
'           Wiecej szczegolow w przykladowym arkuszu.
'
'
' Data          Deweloper           Dzialanie
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' 20 Paz 2005   Stephen Bullen      Utworzyl
'
Public Property Let HandleResizing(bNew As Boolean)
    On Error Resume Next
    If Not moCTP Is Nothing Then moCTP.ContentControl.HandleResizing = bNew
End Property

Public Property Get HandleResizing() As Boolean
    On Error Resume Next
    If Not moCTP Is Nothing Then HandleResizing = moCTP.ContentControl.HandleResizing
End Property


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komentarze: Usuwa panel zadan przy konczeniu dzialania klasy.
'           Typowo dzieje sie to gdy formularz jest wyladowywany.
'
' Data          Deweloper           Dzialanie
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' 20 Paz 2005   Stephen Bullen      Utworzyl
'
Private Sub Class_Terminate()
    On Error Resume Next
    If Not moCTP Is Nothing Then moCTP.Delete
End Sub

