USE Northwind
GO

IF OBJECT_ID(N'dbo.spPobierzNazwyKlientow') IS NOT NULL
	DROP PROC dbo.spPobierzNazwyKlientow
GO

CREATE PROC spPobierzNazwyKlientow
	@Country	nvarchar(24)
AS
	SELECT		CustomerID,
				CompanyName,
				ContactName
	FROM		Customers
	WHERE		Country = @Country
	ORDER BY	CompanyName
GO

IF OBJECT_ID(N'dbo.spWstawSpedytora') IS NOT NULL
	DROP PROC dbo.spWstawSpedytora
GO

CREATE PROC spWstawSpedytora
   @NazwaFirmy	nvarchar(40),
   @Telefon	nvarchar(24)
AS
   INSERT INTO Shippers(CompanyName, Phone)
   VALUES(@NazwaFirmy, @Telefon)
   RETURN @@IDENTITY
GO

IF OBJECT_ID(N'dbo.spPobierzWartosciList') IS NOT NULL
	DROP PROC dbo.spPobierzWartosciList
GO

CREATE PROC spPobierzWartosciList
AS
	-- Lista klientow
	SELECT	CustomerID,
			CompanyName
	FROM	Customers

	-- Lista spedytorow
	SELECT	ShipperID,
			CompanyName
	FROM	Shippers
GO