VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Zlozona"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'***************************************************************************
'*
'* NAZWA MODULU:    EXCEL 2007 PROGRAMMERS REFERENCE AUTOMATION ADDIN
'* AUTOR:           STEPHEN BULLEN, Business Modelling Solutions Ltd.
'*
'* KONTAKT:         Stephen@OALtd.co.uk
'* WWW:             http://www.OALtd.co.uk
'*
'* OPIS:            Dodatek automatyzacji dla Excel 2007
'*
'* TEN MODUL:       Przyklad zlozonego dodatku automatyzacji, ktory implementuje
'*                  interfejs IDTExtensibility2 w celu uzyskanie referencji do obiektu
'*                  Aplikacji Excela, ktora uzywa dodatku
'*
'* PROCEDURY:
'*  IDTExtensibility2_OnConnection          Wywoluje interfejs, gdy Excel otwiera dodatek
'*  IDTExtensibility2_OnDisconnection       Wywoluje interfejs, gdy Excal zamyka dodatek
'*  IDTExtensibility2_OnAddInsUpdate        Nie uzywane przez dodatki automatyzacji
'*  IDTExtensibility2_OnBeginShutdown       Nie uzywane przez dodatki automatyzacji
'*  IDTExtensibility2_OnStartupComplete     Nie uzywane przez dodatki automatyzacji
'*
'*  LosoweUnikalne                          Funkcja zwracajace zbior losowych liczb calkowitych bez powtorzen
'*  Sort2DPion                              Metoda QuickSort do sortowania tablicy 2D
'*
'***************************************************************************

Option Explicit

'Implementuje interfejs IDTExtensibility2, aby Excel mogl wywolywac klase
Implements IDTExtensibility2

'Declaruje prywatny wskaznik do aplikacji Excela
Private moXL As Excel.Application


'Wywolywane przez Excel, gdy klasa jest ladowana, przekazujac wskaznik do obiektu Excela
Private Sub IDTExtensibility2_OnConnection(ByVal Application As Object, _
                                           ByVal ConnectMode As AddInDesignerObjects.ext_ConnectMode, _
                                           ByVal AddInInst As Object, custom() As Variant)

    'Okreslenie referencji do aplikacjie Excela, dla uzycia w funckjach
    Set moXL = Application
    
    'Inicjalizowanie generatora liczb losowych  VB, poniewaz uzywa sie  Rnd()
    Randomize
    
End Sub


'Wywolywane przez Excel gdy klasa jest wyladowywane, wiec niszczymy referencje do Excela
Private Sub IDTExtensibility2_OnDisconnection(ByVal RemoveMode As AddInDesignerObjects.ext_DisconnectMode, _
                                              custom() As Variant)
    Set moXL = Nothing
End Sub


'Nie uzywane przez dodatki automatyzacji, ale musi by zawarte w klasie do implementacji interfejsu
Private Sub IDTExtensibility2_OnAddInsUpdate(custom() As Variant)
' Komentarz, aby VB nie usunal tej metody przy czyszczeniu
End Sub


'Nie uzywane przez dodatki automatyzacji, ale musi by zawarte w klasie do implementacji interfejsu
Private Sub IDTExtensibility2_OnBeginShutdown(custom() As Variant)
' Komentarz, aby VB nie usunal tej metody przy czyszczeniu
End Sub


'Nie uzywane przez dodatki automatyzacji, ale musi by zawarte w klasie do implementacji interfejsu
Private Sub IDTExtensibility2_OnStartupComplete(custom() As Variant)
' Komentarz, aby VB nie usunal tej metody przy czyszczeniu
End Sub


'***************************************************************************
'*
'* NAZWA FUNKCJI:   LosoweUnikalne
'*
'* OPIS:            Zwraca tablic losowych liczb calkowitych z podanego zakresu, bez duplikatow
'*
'* PARAMETRY:       Min       Dolny limit liczb losowych
'*                  Max       Gorny limit liczb losowych
'*
'***************************************************************************

Public Function LosoweUnikalne(Min As Long, Max As Long, Optional Elementy As Long) As Variant

    Dim oRng As Range
    Dim vaWartosci() As Double, vaWynik() As Double
    Dim iElementy As Long, i As Long, iWartosc As Long
    Dim iWiersze As Long, iKolumny As Long, iWiersz As Long, iKolumna As Long

    'Poinformowanie Excela, ze funkcja jest ulotne i powinna byc wywolywana
    'za kazdym razem, gdy arkusz jest przeliczany
    moXL.Volatile

    'Jesli podano ile elementow jest wymaganych, uzywamy tej wartosci...
    If Elementy > 0 Then
        iWiersze = 1
        iKolumny = Elementy
    Else
        
        '... w przeciwnym przypadku pobieramy zakres komorek, w ktorych jest ta funkcje(jako formula tablicy)
        Set oRng = moXL.Caller
        
        iWiersze = oRng.Rows.Count
        iKolumny = oRng.Columns.Count
    End If

    'Ile jest komorek w zakresie
    iElementy = iWiersze * iKolumny

    'Nie mozna wygenerowac unikalnego zbieru liczb jesli jest wiecej komorek do wypelnienia
    'niz liczb z ktorych mozna wybierac, wiec zwraca wartosc bledu w tym przypadku
    If iElementy > (Max - Min + 1) Then
        LosoweUnikalne = CVErr(xlErrValue)
        Exit Function
    End If

    'Wypelnianie tabeli wszystkimi mozliwymi liczbami do wyboru
    'i kolumny liczb losowych do posortowania
    ReDim vaWartosci(Min To Max, 1 To 2)
    For i = Min To Max
        vaWartosci(i, 1) = i
        vaWartosci(i, 2) = Rnd()
    Next

    'Sortowanie tabeli wedlug kolumny liczb losowych, mieszajac tabele
    Sort2DPion vaWartosci, 2, "R"

    'Wymiary tabeli beda tego samego rozmiaru jak zakres z ktorego wywoluwalismy funkcje
    ReDim vaWynik(1 To iWiersze, 1 To iKolumny)

    'Rozpoczecie licznika na poczatku przemieszanej tabeli
    iWartosc = Min

    'Fill the result array from the jumbled array of all values
    For iWiersz = 1 To iWiersze
        For iKolumna = 1 To iKolumny
            vaWynik(iWiersz, iKolumna) = vaWartosci(iWartosc, 1)
            iWartosc = iWartosc + 1
        Next
    Next

    'Zwrocenie wyniku
    LosoweUnikalne = vaWynik

End Function


'***************************************************************************
'*
'* NAZWA FUNKCJI:   SORTOWANIE TABELI - 2D Pionowo
'*
'* OPIS:            Sortuje przekazan tabel w wymaganej kolejnoci, uywajc
'*                  zadanego klucza.  Tablica musi by tablic 2D o dowolnym rozmiarze.
'*
'* PARAMETRY:       avTabela    Tabela wartosci do sortowania
'*                  iKlucz      Kolumna do sortowania
'*                  sKolejnosc  R-Rosnaco, M-Malejaco
'*                  iDol1       The first item to sort between
'*                  iGora1      The last item to sort between
'*
'***************************************************************************

Private Sub Sort2DPion(avTabela As Variant, iKlucz As Integer, sKolejnosc As String, _
                       Optional iDol1, Optional iGora1)


    Dim iDol2 As Integer, iGora2 As Integer, i As Integer
    Dim vElement1, vElement2 As Variant

    On Error GoTo PtrExit

    If IsMissing(iDol1) Then iDol1 = LBound(avTabela)
    If IsMissing(iGora1) Then iGora1 = UBound(avTabela)

    'Okreslenie nowych limitow przez stare
    iDol2 = iDol1
    iGora2 = iGora1

    'Pobranie wartosci tabeli w srodku nowych limitow
    vElement1 = avTabela((iDol1 + iGora1) \ 2, iKlucz)

    'Petla po wszystkich elementach w tablicy pomiedzy limitami
    Do While iDol2 < iGora2

        If sKolejnosc = "R" Then
            'Znalezienie pierwszego elemetntu, ktory jest wiekszy niz element srodkowy
            Do While avTabela(iDol2, iKlucz) < vElement1 And iDol2 < iGora1
                iDol2 = iDol2 + 1
            Loop

            'Znalezienie ostatniego elementu, ktory jest mniejszy niz element srodkowy
            Do While avTabela(iGora2, iKlucz) > vElement1 And iGora2 > iDol1
                iGora2 = iGora2 - 1
            Loop
        Else
            'Znalezienie pierwszego elementu ktory jest mniejszy niz element srodkowy
            Do While avTabela(iDol2, iKlucz) > vElement1 And iDol2 < iGora1
                iDol2 = iDol2 + 1
            Loop

            'Znalezienie ostatniego elementu, ktory jest wiekszy niz element srodkowy
            Do While avTabela(iGora2, iKlucz) < vElement1 And iGora2 > iDol1
                iGora2 = iGora2 - 1
            Loop
        End If

        'Jesli dwa elementy sa w zlej kolejnosci, zamienia wiersze
        If iDol2 < iGora2 Then
            For i = LBound(avTabela, 2) To UBound(avTabela, 2)
                vElement2 = avTabela(iDol2, i)
                avTabela(iDol2, i) = avTabela(iGora2, i)
                avTabela(iGora2, i) = vElement2
            Next
        End If

        'Jesli wskazniki nie sa razem, przechodzi do nastepnego elementu
        If iDol2 <= iGora2 Then
            iDol2 = iDol2 + 1
            iGora2 = iGora2 - 1
        End If
    Loop

    'Rekurencja w celu posortowanie dolnej polowy
    If iGora2 > iDol1 Then Sort2DPion avTabela, iKlucz, sKolejnosc, iDol1, iGora2

    'Rekurencja do posortowanie gornej polowy
    If iDol2 < iGora1 Then Sort2DPion avTabela, iKlucz, sKolejnosc, iDol2, iGora1

PtrExit:

End Sub

