<?php 
 
/** 
 * @file 
 * Strona administracyjna z wywołaniami zwrotnymi modułu annotate. 
 */ 
 
/** 
 * Tworzenie formularza dla ustawień przypisów. 
 * 
 * @ingroup forms 
 * @see system_settings_form(). 
 */ 
function annotate_admin_settings() { 
  // Pobierz tablicę rodzajów segmentów, zawierającą wewnętrzne nazwy jako klucze i przyjazne nazwy jako wartości, np.
  // array('page' => ’Prosta strona', 'article' => 'Artykuły') 
 
  $types = node_type_get_types(); 
  foreach($types as $node_type) {  
     $options[$node_type->type] = $node_type->name; 
  }   
$form['annotate_node_types'] = array(  
    '#type' => 'checkboxes',  
    '#title' => t('Użytkownicy mogą tworzyć przypisy dla następujących rodzajów zawartości'),  
    '#options' => $options,  
    '#default_value' => variable_get('annotate_node_types', array('page')),  
    '#description' => t('Przy wybranych rodzajach zawartości zostaną wyświetlone pola tekstowe w celu umożliwienia dodawania prywatnych uwag przez użytkowników.'),  
  );  
 
  $form['annotate_deletion'] = array( 
    '#type' => 'radios', 
    '#title' => t('Przypisy zostaną usunięte'), 
    '#description' => t('Wybierz metodę usuwania przypisów.'), 
    '#options' => array( 
      t('Nigdy'), 
      t('Losowo'), 
      t('Po 30 dniach') 
    ), 
    '#default_value' => variable_get('annotate_deletion', 0) // Domyślnie: Nigdy 
  ); 
  $form['annotate_limit_per_node'] = array( 
    '#type' => 'textfield', 
    '#title' => t('Liczba przypisów na pojedynczy segment'), 
    '#description' => t('Wprowadź maksymalną dopuszczalną liczbę przypisów dla pojedynczego segmentu (0 – brak limitu)'), 
    '#default_value' => variable_get('annotate_limit_per_node', 1), 
    '#size' => 3 
  ); 
 
  $form['#submit'][] = 'annotate_admin_settings_submit'; 
  return system_settings_form($form);  
}



/** 
* Przetwarzanie formularza ustawień przypisów. 
*/ 
function annotate_admin_settings_submit($form, $form_state) { 
  // Przeiteruj kolekcję checkboksów zawartych w formularzu
  foreach ($form_state['values']['annotate_node_types'] as $key => $value) { 
    // Jeśli checkbox dla danego rodzaju zawartości nie jest zaznaczony, sprawdź czy 
    // dany rodzaj zawartości ma zdefiniowane pole przypisu, korzystając
   //  z funkcji field_info_instance. Jeśli tak, usuń pole przypisu,    
  //   ponieważ administrator odznaczył dane pole formularza.
    if (!$value) { 
      $instance = field_info_instance('node', 'annotation', $key); 
      if (!empty($instance)) { 
        field_delete_instance($instance); 
        watchdog("Przypis", 'Usunięto pole przypisu z następującego rodzaju zawartości: 
        %key', array('%key' => $key)); 
      } 
    } else { 
      // Jeśli checkbox dla danego rodzaju zawartości jest zaznaczony, sprawdź czy
      // pole przypisu dla danego rodzaju zawartości istnieje. Jeśli nie,  
      // dodaj pole przypisu do tego rodzaju zawartości. 
      $instance = field_info_instance('node', 'annotation', $key); 
      if (empty($instance)) { 
        $instance = array( 
          'field_name' => 'annotation', 
          'entity_type' => 'node', 
          'bundle' => $key, 
          'label' => t('Przypis'), 
          'widget_type' => 'text_textarea_with_summary', 
          'settings' => array('display_summary' => TRUE), 
          'display' => array( 
            'default' => array( 
              'type' => 'text_default', 
            ), 
            'teaser' => array( 
              'type' => 'text_summary_or_trimmed', 
            ), 
        ), 
      ); 
      $instance = field_create_instance($instance); 
      watchdog('Przypis', 'Dodano pole przypisu do następującego rodzaju zawartości: %key', 
        array('%key' => $key)); 
      } 
    } 
  } // Koniec pętli foreach. 
}

/** 
 * Walidacja formularza ustawień przypisów.
 */ 
function annotate_admin_settings_validate($form, &$form_state) { 
  $limit = $form_state['values']['annotate_limit_per_node']; 
  if (!is_numeric($limit)) { 
    form_set_error('annotate_limit_per_node', t('Proszę wprowadzić liczbę.')); 
  } 
}
  
?>