//
//  GameViewController.m
//  Game
//
//  Created by Górczyński Robert on 06/01/2012.
//

#import "GameViewController.h"

@implementation GameViewController
@synthesize label;
@synthesize answer;

- (void)dealloc
{
    [answer release];
    [label release];
    
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Usunięcie wszelkich buforowanych danych, obrazów itd., które nie są obecnie używane.
}

- (void)generate
{
    // Wybór dwóch liczb z zakresu od 1 do 9.
    int a = 1 + arc4random() % 9;
    int b = 1 + arc4random() % 9;
    
    // Obliczenie sumy.
    int sum = a + b;
    
    // Utworzenie pytania.
    label.text = [NSString stringWithFormat: @"%d + %d = ", a, b];
    
    // Zapis odpowiedzi we właściwości tag etykiety
    label.tag = sum;
}


#pragma mark - cykl życiowy widoku

// Przeprowadzenie wszelkiej dodatkowej konfiguracji po wczytaniu widoku, najczęściej z pliku nib.
- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self generate];
}

- (void)viewDidUnload
{
    [self setLabel:nil];
    [self setAnswer:nil];
    [super viewDidUnload];
    // Usunięcie wszystkich "przytrzymanych" podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Zwrot wartości YES dla obsługiwanych układów.
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    [self.answer becomeFirstResponder];
}

- (void)viewWillDisappear:(BOOL)animated
{
	[super viewWillDisappear:animated];
}

- (void)viewDidDisappear:(BOOL)animated
{
	[super viewDidDisappear:animated];
}



- (IBAction)submit:(id)sender
{
    // Konwersja odpowiedzi z wartości tekstowej na liczbową.
    int num = [answer.text intValue];
    
    // Sprawdzenie poprawności odpowiedzi poprzez jej porównanie z wartością tag.
    UIAlertView *alert;
    if (num == label.tag)
    {
        // Odpowiedź jest prawidłowa.
        alert = [[UIAlertView alloc] initWithTitle:@"Prawidłowo!"
                                           message:@"Spróbuj inne zadanie!"
                                          delegate:self
                                 cancelButtonTitle:@"OK"
                                 otherButtonTitles:nil];
        
        // Użycie wartości tag do wskazania udzielenia prawidłowej odpowiedzi.
        alert.tag = 1;
    } else 
    {
        // Odpowiedź jest nieprawidłowa.
        alert = [[UIAlertView alloc] initWithTitle:@"Błędnie!"
                                           message:@"Odpowiedź jest nieprawidłowa."
                                          delegate:self
                                 cancelButtonTitle:@"Spróbuj ponownie"
                                 otherButtonTitles:nil];
    }
    
    // Wyświetlenie i usunięcie z pamięci okna komunikatu.
    [alert show];
    [alert release];
}

- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex
{
    if (alertView.tag == 1)
    {
        // Wygenerowanie nowego zadania.
        [self generate];
        
        // Usunięcie poprzednio udzielonej odpowiedzi.
        answer.text = @"";
    }
}

@end
