//
//  Paddle.h
//  AirHockey
//
//  Created by Górczyński Robert on 19/01/2012.
//

#import <Foundation/Foundation.h>

@interface Paddle : NSObject
{
    UIView *view;    // Widok paletki z bieżącą pozycją.
    CGRect boundary; // Prostokąt ograniczający ruch.
    CGPoint pos;     // Położenie, do którego zmierza paletka.
    float maxSpeed;  // Prędkość maksymalna.
    float speed;     // Prędkość bieżąca.
    UITouch *touch;  // Dotknięcie przypisane danej paletce.
}

@property (assign) UITouch *touch;
@property (readonly) float speed;
@property (assign) float maxSpeed;

// Inicjalizacja obiektu.
- (id)initWithView:(UIView *)paddle Boundary:(CGRect)rect MaxSpeed:(float) max;

// Wyzerowanie położenia do środka prostokąta ograniczającego ruch.
- (void)reset;

// Miejsce, do którego powinna zostać przesunięta paletka.
- (void)move:(CGPoint)pt;

// Punkt centralny paletki.
- (CGPoint)center;

// Sprawdzenie, czy paletka przecina się z prostokątem.
- (bool)intersects:(CGRect)rect;

// Ustalenie odległości dzielącej bieżące położenie paletki i punktu.
- (float)distance:(CGPoint)pt;

// Animacja widoku krążka do kolejnego położenia bez przekraczania prędkości maksymalnej.
- (void)animate;

@end
