/*	WYPOZYCZ		*/

CREATE TABLE WYPOZYCZ
(
IDWYPOZYCZ	INTEGER	NOT NULL,
IDOSOBY		INTEGER NOT NULL,
IDKSIAZKI	INTEGER NOT NULL,
ODDNIA		DATE    NOT NULL,
ODDANO		DATE,
CONSTRAINT WYPOZYCZ_PK PRIMARY KEY(IDWYPOZYCZ)
);

ALTER TABLE WYPOZYCZ add constraint WYPOZYCZ_FK_IDOSOBY FOREIGN KEY(idosoby) references OSOBY(idosoby)
ON DELETE NO ACTION;

ALTER TABLE WYPOZYCZ add constraint WYPOZYCZ_FK_IDKSIAZKI FOREIGN KEY(idksiazki) references KSIAZKI(idksiazki)
ON DELETE NO ACTION;

CREATE GENERATOR G_WYPOZYCZ;
SET GENERATOR G_WYPOZYCZ TO -1;

SET TERM ^ ;

CREATE TRIGGER T_WYPOZYCZ FOR WYPOZYCZ
ACTIVE BEFORE INSERT
POSITION 0
AS  
BEGIN
   NEW.IDWYPOZYCZ = GEN_ID(G_WYPOZYCZ, 1);
END
^

SET TERM ; ^

insert into WYPOZYCZ(idosoby, idksiazki, oddnia, oddano) values( 0, 0, '01/01/2002', '03/01/2002');
insert into WYPOZYCZ(idosoby, idksiazki, oddnia, oddano) values( 1, 1, '01/01/2002', '03/01/2002');
insert into WYPOZYCZ(idosoby, idksiazki, oddnia, oddano) values( 2, 2, '01/01/2002', '03/01/2002');
insert into WYPOZYCZ(idosoby, idksiazki, oddnia, oddano) values( 3, 3, '01/01/2002', '03/01/2002');
insert into WYPOZYCZ(idosoby, idksiazki, oddnia) values( 0, 4, '12/26/2002');
insert into WYPOZYCZ(idosoby, idksiazki, oddnia) values( 1, 3, '12/26/2002');
insert into WYPOZYCZ(idosoby, idksiazki, oddnia) values( 2, 2, '12/26/2002');
insert into WYPOZYCZ(idosoby, idksiazki, oddnia) values( 3, 1, '12/26/2002');

select * from WYPOZYCZ;
