#
#  Plik:  mnist_nn_experiments_scatter_plot.py
#
#  Wykres punktowy wyników aktywacji ReLU, gdzie ocena jest okeślana za pomocą rozmiaru znacznika.
#
#  RTK, 30.12.2018
#  Ostatnia aktualizacja:  16.12.2019
#
###############################################################

import matplotlib.pylab as plt
import numpy as np

def main():
    one = np.array([0.8656,0.8683,0.8716,0.8698])
    e1 = np.array([0.0007,0.0006,0.0006,0.0006])

    two = np.array([0.8748,0.8781,0.8808,0.8798])
    e2 = np.array([0.0010,0.0007,0.0006,0.0006])

    three=np.array([0.8778,0.8822,0.8848,0.8864])
    e3 = np.array([0.0011,0.0008,0.0006,0.0007])

    p1 = np.array([795010,1590010,3180010,6360010])
    p2 = np.array([798360,1570335,3173685,6314185])
    p3 = np.array([792505,1580320,3187627,6355475])

    plt.errorbar(p1,one,e1,marker="o",color='red',label='One')
    plt.errorbar(p2,two,e2,marker='s',color='blue',label='Two')
    plt.errorbar(p3,three,e3,marker='^',color='green',label='Three')
    plt.ticklabel_format(axis='x', style='sci', scilimits=(0,0))
    plt.xlabel("Parametry")
    plt.ylabel("Ocena")
    plt.legend(loc='lower right')
    plt.tight_layout()
    plt.savefig("relu_layers.pdf", format="pdf", dpi=600)
    plt.show()


main()

#  Użyj tych: (średnia z 25 modeli)
#Warstwy:        (1000,), Ocena= 0.8656 +/- 0.0007, Strata = 0.3306 +/- 0.0006 (parametry = 795010, czas = 27.88 s)
#Warstwy:        (2000,), Ocena= 0.8683 +/- 0.0006, Strata = 0.3193 +/- 0.0004 (parametry = 1590010, czas = 58.31 s)
#Warstwy:        (4000,), Ocena= 0.8716 +/- 0.0006, Strata = 0.3120 +/- 0.0002 (parametry = 3180010, czas = 112.95 s)
#Warstwy:        (8000,), Ocena= 0.8698 +/- 0.0006, Strata = 0.3075 +/- 0.0001 (parametry = 6360010, czas = 272.07 s)
#Warstwy:     (700, 350), Ocena= 0.8748 +/- 0.0010, Strata = 0.2392 +/- 0.0009 (parametry = 798360, czas = 28.90 s)
#Warstwy:    (1150, 575), Ocena= 0.8781 +/- 0.0007, Strata = 0.2278 +/- 0.0006 (parametry = 1570335, czas = 56.44 s)
#Warstwy:    (1850, 925), Ocena= 0.8808 +/- 0.0006, Strata = 0.2179 +/- 0.0006 (parametry = 3173685, czas = 115.29 s)
#Warstwy:   (2850, 1425), Ocena= 0.8798 +/- 0.0006, Strata = 0.2116 +/- 0.0005 (parametry = 6314185, czas = 231.93 s)
#Warstwy: (660, 330, 165), Ocena= 0.8778 +/- 0.0011, Strata = 0.1810 +/- 0.0016 (parametry = 792505, czas = 29.01 s)
#Warstwy: (1080, 540, 270), Ocena= 0.8822 +/- 0.0008, Strata = 0.1637 +/- 0.0010 (parametry = 1580320, czas = 57.30 s)
#Warstwy: (1714, 857, 429), Ocena= 0.8848 +/- 0.0006, Strata = 0.1534 +/- 0.0007 (parametry = 3187627, czas = 115.90 s)
#Warstwy: (2620, 1310, 655), Ocena= 0.8864 +/- 0.0007, Strata = 0.1460 +/- 0.0006 (parametry = 6355475, czas = 229.24 s)

