#
#  Plik:  esc10_audio_classical.py
#
#  Stosuje klasyczne modele do nieprzetworzonego zbioru danych ESC-10. 
#
#  RTK, 13.11.2019
#  Ostatnia aktualizacja:  13.11.2019
#
###############################################################

import time
import numpy as np
from sklearn.neighbors import NearestCentroid
from sklearn.neighbors import KNeighborsClassifier
from sklearn.naive_bayes import GaussianNB
from sklearn.ensemble import RandomForestClassifier
from sklearn.svm import LinearSVC

def run(x_train, y_train, x_test, y_test, clf):
    """Uczenie i testowanie"""

    s = time.time()
    clf.fit(x_train, y_train)
    e_train = time.time() - s
    s = time.time()
    score = clf.score(x_test, y_test)
    e_test = time.time() - s
    print("Ocena = %0.4f (czas, uczący=%8.3f, testowy=%8.3f)" % (score, e_train, e_test))


def train(x_train, y_train, x_test, y_test):
    """Trenuje modele na wyznaczonym zestawie danych"""

    print("    Najbliższy centroid          : ", end='')
    run(x_train, y_train, x_test, y_test, NearestCentroid())
    print("    Klasyfikator k-NN (k=3)     : ", end='')
    run(x_train, y_train, x_test, y_test, KNeighborsClassifier(n_neighbors=3))
    print("    Klasyfikator k-NN (k=7)     : ", end='')
    run(x_train, y_train, x_test, y_test, KNeighborsClassifier(n_neighbors=7))
    print("    Naiwny klasyfikator Bayesa (gaussowski)    : ", end='')
    run(x_train, y_train, x_test, y_test, GaussianNB())
    print("    Las losowy (drzewa=  5) : ", end='')
    run(x_train, y_train, x_test, y_test, RandomForestClassifier(n_estimators=5))
    print("    Las losowy (drzewa= 50) : ", end='')
    run(x_train, y_train, x_test, y_test, RandomForestClassifier(n_estimators=50))
    print("    Las losowy (drzewa= 500) : ", end='')
    run(x_train, y_train, x_test, y_test, RandomForestClassifier(n_estimators=500))
    print("    Las losowy (drzewa= 1000): ", end='')
    run(x_train, y_train, x_test, y_test, RandomForestClassifier(n_estimators=1000))
    print("    LinearSVM (C=0.01)        : ", end='')
    run(x_train, y_train, x_test, y_test, LinearSVC(C=0.01))
    print("    LinearSVM (C=0.1)         : ", end='')
    run(x_train, y_train, x_test, y_test, LinearSVC(C=0.1))
    print("    LinearSVM (C=1.0)         : ", end='')
    run(x_train, y_train, x_test, y_test, LinearSVC(C=1.0))
    print("    LinearSVM (C=10.0)        : ", end='')
    run(x_train, y_train, x_test, y_test, LinearSVC(C=10.0))


def main():
    """Przeprowadza eksperymenty na danych ESC-10"""

    #  Wczytuje i skaluje dane
    x_train = np.load("../data/audio/ESC-10/esc10_raw_train_audio.npy")[:,:,0]
    y_train = np.load("../data/audio/ESC-10/esc10_raw_train_labels.npy")
    x_test  = np.load("../data/audio/ESC-10/esc10_raw_test_audio.npy")[:,:,0]
    y_test  = np.load("../data/audio/ESC-10/esc10_raw_test_labels.npy")

    x_train = (x_train.astype('float32') + 32768) / 65536
    x_test = (x_test.astype('float32') + 32768) / 65536

    #  Trenuje i testuje modele
    train(x_train, y_train, x_test, y_test)


main()

